/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.format;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.openapi.OpenApiExample;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30Example;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31Example;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class OasInvalidExampleDescriptionRule
extends ValidationRule {
    public OasInvalidExampleDescriptionRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitExample(OpenApiExample node) {
        if (node.root().modelType() == ModelType.OPENAPI30) {
            OpenApi30Example example30 = (OpenApi30Example)node;
            if (this.hasValue(example30.getDescription())) {
                this.reportIfInvalid(this.isValidCommonMark(example30.getDescription()), example30, "description", this.map(new String[0]));
            }
        } else {
            OpenApi31Example example31 = (OpenApi31Example)node;
            if (this.hasValue(example31.getDescription())) {
                this.reportIfInvalid(this.isValidCommonMark(example31.getDescription()), example31, "description", this.map(new String[0]));
            }
        }
    }
}

