/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.invalid.format;

import io.apicurio.datamodels.models.ModelType;
import io.apicurio.datamodels.models.SecurityScheme;
import io.apicurio.datamodels.models.asyncapi.AsyncApiSecurityScheme;
import io.apicurio.datamodels.models.openapi.v30.OpenApi30SecurityScheme;
import io.apicurio.datamodels.models.openapi.v31.OpenApi31SecurityScheme;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;

public class OasInvalidOpenIDConnectUrlRule
extends ValidationRule {
    public OasInvalidOpenIDConnectUrlRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitSecurityScheme(SecurityScheme node) {
        if (node.root().modelType() == ModelType.OPENAPI30) {
            OpenApi30SecurityScheme scheme = (OpenApi30SecurityScheme)node;
            if (this.hasValue(scheme.getOpenIdConnectUrl())) {
                this.reportIfInvalid(this.isValidUrl(scheme.getOpenIdConnectUrl()), scheme, "openIdConnectUrl", this.map(new String[0]));
            }
        } else if (node.root().modelType() == ModelType.OPENAPI31) {
            OpenApi31SecurityScheme scheme = (OpenApi31SecurityScheme)node;
            if (this.hasValue(scheme.getOpenIdConnectUrl())) {
                this.reportIfInvalid(this.isValidUrl(scheme.getOpenIdConnectUrl()), scheme, "openIdConnectUrl", this.map(new String[0]));
            }
        } else {
            AsyncApiSecurityScheme scheme = (AsyncApiSecurityScheme)node;
            if (this.hasValue(scheme.getOpenIdConnectUrl())) {
                this.reportIfInvalid(this.isValidUrl(scheme.getOpenIdConnectUrl()), scheme, "openIdConnectUrl", this.map(new String[0]));
            }
        }
    }
}

