/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.datamodels.validation.rules.other;

import io.apicurio.datamodels.models.Operation;
import io.apicurio.datamodels.models.openapi.OpenApiOperation;
import io.apicurio.datamodels.validation.ValidationRule;
import io.apicurio.datamodels.validation.ValidationRuleMetaData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OasOperationIdUniquenessValidationRule
extends ValidationRule {
    private Map<String, List<Operation>> indexedOperations = new HashMap<String, List<Operation>>();

    public OasOperationIdUniquenessValidationRule(ValidationRuleMetaData ruleInfo) {
        super(ruleInfo);
    }

    @Override
    public void visitOperation(Operation node) {
        OpenApiOperation operation = (OpenApiOperation)node;
        if (this.hasValue(operation.getOperationId())) {
            List<Operation> dupes = this.indexedOperations.get(operation.getOperationId());
            if (this.hasValue(dupes)) {
                this.reportIfInvalid(dupes.size() > 1, dupes.get(0), "operationId", this.map("operationId", operation.getOperationId()));
                this.report(node, "operationId", this.map("operationId", operation.getOperationId()));
                dupes.add(node);
            } else {
                dupes = new ArrayList<Operation>();
                dupes.add(node);
                this.indexedOperations.put(operation.getOperationId(), dupes);
            }
        }
    }
}

