/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rules.compatibility.AbstractCompatibilityChecker;
import io.apicurio.registry.rules.compatibility.CompatibilityDifference;
import io.apicurio.registry.rules.compatibility.SimpleCompatibilityDifference;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.OpenApiCompare;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ChangedOpenApi;
import org.openapitools.openapidiff.core.model.ChangedOperation;
import org.openapitools.openapidiff.core.model.ChangedSchema;
import org.openapitools.openapidiff.core.model.Endpoint;

public class OpenApiCompatibilityChecker
extends AbstractCompatibilityChecker<Object> {
    protected Set<Object> isBackwardsCompatibleWith(String existing, String proposed, Map<String, TypedContent> resolvedReferences) {
        ChangedOpenApi diff = OpenApiCompare.fromContents((String)existing, (String)proposed);
        List<ChangedOperation> incompatibleOperations = diff.getChangedOperations().stream().filter(Objects::nonNull).filter(Changed::isIncompatible).toList();
        List<ChangedSchema> incompatibleSchemas = diff.getChangedSchemas().stream().filter(Objects::nonNull).filter(Changed::isIncompatible).toList();
        List<Endpoint> missingEndpoints = diff.getMissingEndpoints().stream().filter(Objects::nonNull).toList();
        return Stream.of(incompatibleOperations, incompatibleSchemas, missingEndpoints).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    protected CompatibilityDifference transform(Object original) {
        if (original instanceof ChangedOperation) {
            return new SimpleCompatibilityDifference("Incompatible operation", ((ChangedOperation)original).getPathUrl());
        }
        if (original instanceof ChangedSchema) {
            return new SimpleCompatibilityDifference("Incompatible schema", ((ChangedSchema)original).getNewSchema().getName());
        }
        if (original instanceof Endpoint) {
            return new SimpleCompatibilityDifference("Missing endpoint", ((Endpoint)original).getPathUrl());
        }
        throw new IllegalArgumentException("Unsupported type: " + original.getClass().getName());
    }
}

