/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.TraverserDirection;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.models.Referenceable;
import io.apicurio.datamodels.models.visitors.AllNodeVisitor;
import io.apicurio.datamodels.models.visitors.Visitor;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.util.ContentTypeUtil;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public abstract class ApicurioDataModelContentValidator
implements ContentValidator {
    public void validate(ValidityLevel level, TypedContent content, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        List problems;
        Document document = null;
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                JsonNode node = ContentTypeUtil.parseJsonOrYaml((TypedContent)content);
                document = Library.readDocument((ObjectNode)((ObjectNode)node));
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for " + this.getDataModelType() + " artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
        if (level == ValidityLevel.FULL && !(problems = Library.validate((Node)document, null)).isEmpty()) {
            Set causes = problems.stream().map(problem -> new RuleViolation(problem.message, problem.nodePath.toString())).collect(Collectors.toSet());
            throw new RuleViolationException("The " + this.getDataModelType() + " artifact is not semantically valid. " + problems.size() + " problems found.", RuleType.VALIDITY, level.name(), causes);
        }
    }

    public void validateReferences(TypedContent content, List<ArtifactReference> references) throws RuleViolationException {
        Set mappedRefs = references.stream().map(ref -> ref.getName()).collect(Collectors.toSet());
        Set<String> all$refs = this.getAll$refs(content);
        Set violations = all$refs.stream().filter(ref -> !mappedRefs.contains(ref)).map(missingRef -> new RuleViolation("Unmapped reference detected.", missingRef)).collect(Collectors.toSet());
        if (!violations.isEmpty()) {
            throw new RuleViolationException("Unmapped reference(s) detected.", RuleType.INTEGRITY, IntegrityLevel.ALL_REFS_MAPPED.name(), violations);
        }
    }

    private Set<String> getAll$refs(TypedContent content) {
        try {
            RefFinder refFinder = new RefFinder();
            JsonNode node = ContentTypeUtil.parseJsonOrYaml((TypedContent)content);
            Document document = Library.readDocument((ObjectNode)((ObjectNode)node));
            Library.visitTree((Node)document, (Visitor)refFinder, (TraverserDirection)TraverserDirection.down);
            return refFinder.references;
        }
        catch (Exception e) {
            return Collections.emptySet();
        }
    }

    protected abstract String getDataModelType();

    private static class RefFinder
    extends AllNodeVisitor {
        Set<String> references = new HashSet<String>();

        private RefFinder() {
        }

        protected void visitNode(Node node) {
            String theRef;
            if (node instanceof Referenceable && (theRef = ((Referenceable)node).get$ref()) != null && !theRef.startsWith("#/")) {
                this.references.add(theRef);
            }
        }
    }
}

