/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.logging.audit;

import io.apicurio.common.apps.logging.audit.AuditLogService;
import io.apicurio.common.apps.logging.audit.AuditMetaDataExtractor;
import io.apicurio.common.apps.logging.audit.Audited;
import io.quarkus.security.identity.SecurityIdentity;
import jakarta.annotation.Priority;
import jakarta.enterprise.inject.Instance;
import jakarta.inject.Inject;
import jakarta.interceptor.AroundInvoke;
import jakarta.interceptor.Interceptor;
import jakarta.interceptor.InvocationContext;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.beanutils.BeanUtils;

@Audited
@Interceptor
@Priority(value=1900)
public class AuditedInterceptor {
    @Inject
    AuditLogService auditLogService;
    @Inject
    Instance<SecurityIdentity> securityIdentity;
    @Inject
    Instance<AuditMetaDataExtractor> extractors;

    @AroundInvoke
    public Object auditMethod(InvocationContext context) throws Exception {
        Audited annotation = context.getMethod().getAnnotation(Audited.class);
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.securityIdentity.isResolvable() && !((SecurityIdentity)this.securityIdentity.get()).isAnonymous()) {
            metadata.put("principal_id", ((SecurityIdentity)this.securityIdentity.get()).getPrincipal().getName());
        }
        this.extractMetaData(context, annotation, metadata);
        String action = annotation.action();
        if (action.isEmpty()) {
            action = context.getMethod().getName();
        }
        String result = "success";
        try {
            Object object = context.proceed();
            return object;
        }
        catch (Exception e) {
            result = "failure";
            metadata.put("error_msg", e.getMessage());
            throw e;
        }
        finally {
            this.auditLogService.log("apicurio.audit", action, result, metadata, null);
        }
    }

    protected void extractMetaData(InvocationContext context, Audited annotation, Map<String, String> metadata) {
        block6: {
            block5: {
                String[] annotationParams = annotation.extractParameters();
                if (annotationParams.length <= 0) break block5;
                for (int i = 0; i <= annotationParams.length - 2; i += 2) {
                    String position = annotationParams[i];
                    String metadataName = annotationParams[i + 1];
                    String propertyName = null;
                    if (position.contains(".")) {
                        position = this.extractPosition(position);
                        propertyName = this.extractPropertyName(position);
                    }
                    int positionInt = Integer.parseInt(position);
                    Object parameterValue = context.getParameters()[positionInt];
                    if (parameterValue != null && propertyName != null) {
                        parameterValue = this.getPropertyValueFromParam(parameterValue, propertyName);
                    }
                    if (parameterValue == null) continue;
                    metadata.put(metadataName, parameterValue.toString());
                }
                break block6;
            }
            if (!this.extractors.iterator().hasNext()) break block6;
            for (Object parameter : context.getParameters()) {
                for (AuditMetaDataExtractor extractor : this.extractors) {
                    if (!extractor.accept(parameter)) continue;
                    extractor.extractMetaDataInto(parameter, metadata);
                }
            }
        }
    }

    private String extractPosition(String position) {
        return position.split(".")[0];
    }

    private String extractPropertyName(String position) {
        return position.split(".")[1];
    }

    private String getPropertyValueFromParam(Object parameterValue, String propertyName) {
        try {
            return BeanUtils.getProperty((Object)parameterValue, (String)propertyName);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            return parameterValue.toString();
        }
    }
}

