/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.dereference;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.dereference.ContentDereferencer;
import io.apicurio.registry.content.refs.JsonPointerExternalReference;
import io.vertx.core.json.JsonObject;
import io.vertx.json.schema.Draft;
import io.vertx.json.schema.JsonSchema;
import io.vertx.json.schema.JsonSchemaOptions;
import io.vertx.json.schema.impl.JsonRef;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonSchemaDereferencer
implements ContentDereferencer {
    private static final ObjectMapper objectMapper;
    private static final Logger log;
    private static final String idKey = "$id";
    private static final String schemaKey = "$schema";

    public TypedContent dereference(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        String id = null;
        String schema = null;
        try {
            JsonNode contentNode = objectMapper.readTree(content.getContent().content());
            id = contentNode.get(idKey).asText();
            schema = contentNode.get(schemaKey).asText();
        }
        catch (JsonProcessingException e) {
            log.warn("No schema or id provided for schema");
        }
        JsonSchemaOptions jsonSchemaOptions = new JsonSchemaOptions().setBaseUri("http://localhost");
        if (null != schema) {
            jsonSchemaOptions.setDraft(Draft.fromIdentifier((String)schema));
        }
        HashMap<String, JsonSchema> lookups = new HashMap<String, JsonSchema>();
        this.resolveReferences(resolvedReferences, lookups);
        JsonObject resolvedSchema = JsonRef.resolve((JsonObject)new JsonObject(content.getContent().content()), lookups);
        if (null != id) {
            resolvedSchema.put(idKey, (Object)id);
        }
        if (schema != null) {
            resolvedSchema.put(schemaKey, (Object)schema);
        }
        return TypedContent.create((ContentHandle)ContentHandle.create((String)resolvedSchema.encodePrettily()), (String)content.getContentType());
    }

    private void resolveReferences(Map<String, TypedContent> resolvedReferences, Map<String, JsonSchema> lookups) {
        resolvedReferences.forEach((referenceName, schema) -> {
            JsonPointerExternalReference externalRef = new JsonPointerExternalReference(referenceName);
            lookups.computeIfAbsent(externalRef.getResource(), key -> {
                JsonObject resolvedSchema = JsonRef.resolve((JsonObject)new JsonObject(schema.getContent().content()), (Map)lookups);
                return JsonSchema.of((JsonObject)resolvedSchema);
            });
        });
    }

    public TypedContent rewriteReferences(TypedContent content, Map<String, String> resolvedReferenceUrls) {
        try {
            JsonNode tree = objectMapper.readTree(content.getContent().content());
            this.rewriteIn(tree, resolvedReferenceUrls);
            String converted = objectMapper.writeValueAsString(objectMapper.treeToValue((TreeNode)tree, Object.class));
            return TypedContent.create((ContentHandle)ContentHandle.create((String)converted), (String)content.getContentType());
        }
        catch (Exception e) {
            return content;
        }
    }

    private void rewriteIn(JsonNode node, Map<String, String> resolvedReferenceUrls) {
        if (node.isObject()) {
            this.rewriteInObject((ObjectNode)node, resolvedReferenceUrls);
        }
    }

    private void rewriteInObject(ObjectNode node, Map<String, String> resolvedReferenceUrls) {
        String $ref;
        if (node.hasNonNull("$ref") && resolvedReferenceUrls.containsKey($ref = node.get("$ref").asText())) {
            node.put("$ref", resolvedReferenceUrls.get($ref));
        }
        Iterator fieldNames = node.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode fieldValue = node.get(fieldName);
            if (!fieldValue.isObject()) continue;
            this.rewriteInObject((ObjectNode)fieldValue, resolvedReferenceUrls);
        }
    }

    static {
        log = LoggerFactory.getLogger(JsonSchemaDereferencer.class);
        objectMapper = new ObjectMapper();
        objectMapper.registerModule((Module)new ParameterNamesModule());
        objectMapper.registerModule((Module)new Jdk8Module());
        objectMapper.registerModule((Module)new JavaTimeModule());
        objectMapper.registerModule((Module)new JsonOrgModule());
        objectMapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        objectMapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        objectMapper.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }
}

