/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TextNode;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsonorg.JsonOrgModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.types.RegistryException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.everit.json.schema.Schema;
import org.everit.json.schema.loader.SchemaLoader;
import org.everit.json.schema.loader.SpecificationVersion;
import org.everit.json.schema.loader.internal.ReferenceResolver;
import org.json.JSONObject;

public class JsonUtil {
    public static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String SCHEMA_KEYWORD = "$schema";

    public static Schema readSchema(String content) throws JsonProcessingException {
        return JsonUtil.readSchema(content, Collections.emptyMap(), true);
    }

    public static Schema readSchema(String content, Map<String, TypedContent> resolvedReferences) throws JsonProcessingException {
        return JsonUtil.readSchema(content, resolvedReferences, true);
    }

    public static Schema readSchema(String content, Map<String, TypedContent> resolvedReferences, boolean validateDangling) throws JsonProcessingException {
        String id;
        String schema;
        JsonNode jsonNode = MAPPER.readTree(content);
        SpecificationVersion spec = SpecificationVersion.DRAFT_7;
        if (jsonNode.has(SCHEMA_KEYWORD) && (schema = jsonNode.get(SCHEMA_KEYWORD).asText()) != null) {
            spec = SpecificationVersion.lookupByMetaSchemaUrl((String)schema).orElse(SpecificationVersion.DRAFT_7);
        }
        URI idUri = null;
        if (jsonNode.has(spec.idKeyword()) && (id = jsonNode.get(spec.idKeyword()).asText()) != null) {
            idUri = ReferenceResolver.resolve((URI)null, (String)id);
        }
        List refNodes = jsonNode.findValues("$ref");
        List refStrings = refNodes.stream().filter(JsonNode::isTextual).map(TextNode.class::cast).map(TextNode::textValue).collect(Collectors.toList());
        SchemaLoader.SchemaLoaderBuilder builder = SchemaLoader.builder().useDefaults(true).draftV7Support();
        HashMap<String, TypedContent> resolvedReferencesCopy = new HashMap<String, TypedContent>(resolvedReferences);
        ArrayList<URI> referenceURIs = new ArrayList<URI>();
        for (String refString : refStrings) {
            URI referenceURI = ReferenceResolver.resolve((URI)idUri, (String)refString);
            referenceURIs.add(referenceURI);
            TypedContent resolvedReference = resolvedReferencesCopy.remove(referenceURI.toString());
            if (resolvedReference != null) {
                builder.registerSchemaByURI(referenceURI, (Object)new JSONObject(resolvedReference.getContent().content()));
                continue;
            }
            builder.registerSchemaByURI(referenceURI, (Object)new JSONObject());
        }
        if (validateDangling && !resolvedReferencesCopy.isEmpty()) {
            String msg = "There are unused references recorded for this content. Make sure you have not made a typo, otherwise remove the unused reference record(s). References in the content: " + referenceURIs + ", Unused reference records: " + new ArrayList<String>(resolvedReferencesCopy.keySet());
            throw new RegistryException(msg);
        }
        JSONObject jsonObject = (JSONObject)MAPPER.treeToValue((TreeNode)jsonNode, JSONObject.class);
        builder.schemaJson(jsonObject);
        SchemaLoader loader = builder.build();
        Schema schemaObj = loader.load().build();
        return schemaObj;
    }

    static {
        MAPPER.registerModule((Module)new JsonOrgModule());
        MAPPER.registerModule((Module)new ParameterNamesModule());
        MAPPER.registerModule((Module)new Jdk8Module());
        MAPPER.registerModule((Module)new JavaTimeModule());
        MAPPER.registerModule((Module)new JsonOrgModule());
        MAPPER.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
        MAPPER.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        MAPPER.setNodeFactory(JsonNodeFactory.withExactBigDecimals((boolean)true));
    }
}

