/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.compatibility.jsonschema.diff;

import io.apicurio.registry.rules.compatibility.jsonschema.JsonSchemaWrapperVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffContext;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffType;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.DiffUtil;
import io.apicurio.registry.rules.compatibility.jsonschema.diff.SchemaDiffVisitor;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.ArraySchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.SchemaWrapper;
import io.apicurio.registry.rules.compatibility.jsonschema.wrapper.WrapUtil;
import java.util.List;
import java.util.Optional;
import org.everit.json.schema.ArraySchema;
import org.everit.json.schema.Schema;

public class ArraySchemaDiffVisitor
extends JsonSchemaWrapperVisitor {
    private final DiffContext ctx;
    private final ArraySchema original;
    private ArraySchemaWrapper schema;

    public ArraySchemaDiffVisitor(DiffContext ctx, ArraySchema original) {
        this.ctx = ctx;
        this.original = original;
    }

    @Override
    public void visitArraySchema(ArraySchemaWrapper arraySchema) {
        this.ctx.log("Visiting " + arraySchema + " at " + arraySchema.getWrapped().getLocation());
        this.schema = arraySchema;
        super.visitArraySchema(arraySchema);
    }

    @Override
    public void visitMinItems(Integer minItems) {
        DiffUtil.diffInteger(this.ctx.sub("minItems"), this.original.getMinItems(), minItems, DiffType.ARRAY_TYPE_MIN_ITEMS_ADDED, DiffType.ARRAY_TYPE_MIN_ITEMS_REMOVED, DiffType.ARRAY_TYPE_MIN_ITEMS_INCREASED, DiffType.ARRAY_TYPE_MIN_ITEMS_DECREASED);
        super.visitMinItems(minItems);
    }

    @Override
    public void visitMaxItems(Integer maxItems) {
        DiffUtil.diffInteger(this.ctx.sub("maxItems"), this.original.getMaxItems(), maxItems, DiffType.ARRAY_TYPE_MAX_ITEMS_ADDED, DiffType.ARRAY_TYPE_MAX_ITEMS_REMOVED, DiffType.ARRAY_TYPE_MAX_ITEMS_INCREASED, DiffType.ARRAY_TYPE_MAX_ITEMS_DECREASED);
        super.visitMaxItems(maxItems);
    }

    @Override
    public void visitUniqueItems(boolean uniqueItems) {
        DiffUtil.diffBooleanTransition(this.ctx.sub("uniqueItems"), this.original.needsUniqueItems(), uniqueItems, false, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_FALSE_TO_TRUE, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_TRUE_TO_FALSE, DiffType.ARRAY_TYPE_UNIQUE_ITEMS_BOOLEAN_UNCHANGED);
        super.visitUniqueItems(uniqueItems);
    }

    @Override
    public void visitAllItemSchema(SchemaWrapper allItemSchema) {
        this.ctx.log("visitAllItemSchema: " + allItemSchema + " orig.: " + this.original.getAllItemSchema());
        DiffContext subCtx = this.ctx.sub("allItemSchema");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getAllItemSchema(), allItemSchema, DiffType.ARRAY_TYPE_ALL_ITEM_SCHEMA_ADDED, DiffType.ARRAY_TYPE_ALL_ITEM_SCHEMA_REMOVED)) {
            allItemSchema.accept(new SchemaDiffVisitor(subCtx, this.original.getAllItemSchema()));
        }
        super.visitAllItemSchema(allItemSchema);
    }

    @Override
    public void visitAdditionalItems(boolean additionalItems) {
        this.ctx.log("visitAdditionalItems: " + additionalItems);
        if (DiffUtil.diffBooleanTransition(this.ctx.sub("additionalItems"), this.original.permitsAdditionalItems(), additionalItems, true, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_FALSE_TO_TRUE, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_TRUE_TO_FALSE, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_BOOLEAN_UNCHANGED) && additionalItems) {
            Schema updatedSchemaOfAdditionalItems = this.schema.getSchemaOfAdditionalItems() == null ? null : this.schema.getSchemaOfAdditionalItems().getWrapped();
            DiffUtil.diffSchemaOrTrue(this.ctx.sub("schemaOfAdditionalItems"), this.original.getSchemaOfAdditionalItems(), updatedSchemaOfAdditionalItems, DiffType.ARRAY_TYPE_SCHEMA_OF_ADDITIONAL_ITEMS_UNCHANGED, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_EXTENDED, DiffType.ARRAY_TYPE_ADDITIONAL_ITEMS_NARROWED, DiffType.ARRAY_TYPE_SCHEMA_OF_ADDITIONAL_ITEMS_CHANGED);
        }
        super.visitAdditionalItems(additionalItems);
    }

    @Override
    public void visitItemSchemas(List<SchemaWrapper> itemSchemas) {
        this.ctx.log("visitItemSchemas: " + itemSchemas);
        int originalSize = Optional.ofNullable(this.original.getItemSchemas()).map(s -> s.size()).orElse(0);
        int updatedSize = Optional.ofNullable(itemSchemas).map(s -> s.size()).orElse(0);
        int size = Math.min(originalSize, updatedSize);
        for (int i = 0; i < size; ++i) {
            this.visitItemSchema(i, itemSchemas.get(i));
        }
        if (updatedSize > size) {
            DiffUtil.diffSubSchemasAdded(this.ctx.sub("addItemSchema"), itemSchemas.subList(size, updatedSize), this.original.permitsAdditionalItems(), WrapUtil.wrap(this.original.getSchemaOfAdditionalItems()), this.schema.permitsAdditionalItems(), DiffType.ARRAY_TYPE_ITEM_SCHEMAS_EXTENDED, DiffType.ARRAY_TYPE_ITEM_SCHEMAS_NARROWED, DiffType.ARRAY_TYPE_ITEM_SCHEMAS_CHANGED);
        }
        if (originalSize > size) {
            DiffUtil.diffSubSchemasRemoved(this.ctx.sub("removeItemSchema"), WrapUtil.wrap(this.original.getItemSchemas().subList(size, originalSize)), this.schema.permitsAdditionalItems(), this.schema.getSchemaOfAdditionalItems(), this.original.permitsAdditionalItems(), DiffType.ARRAY_TYPE_ITEM_SCHEMAS_NARROWED, DiffType.ARRAY_TYPE_ITEM_SCHEMAS_NARROWED_COMPATIBLE_WITH_ADDITIONAL_PROPERTIES, DiffType.ARRAY_TYPE_ITEM_SCHEMAS_EXTENDED, DiffType.ARRAY_TYPE_ITEM_SCHEMAS_CHANGED);
        }
        super.visitItemSchemas(itemSchemas);
    }

    @Override
    public void visitItemSchema(int index, SchemaWrapper itemSchema) {
        this.ctx.log("visitItemSchema: " + itemSchema);
        DiffContext subCtx = this.ctx.sub("items/" + index);
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, DiffUtil.getExceptionally(subCtx, () -> (Schema)this.original.getItemSchemas().get(index)), itemSchema, DiffType.ARRAY_TYPE_ITEM_SCHEMA_ADDED, DiffType.ARRAY_TYPE_ITEM_SCHEMA_REMOVED)) {
            itemSchema.accept(new SchemaDiffVisitor(subCtx, (Schema)this.original.getItemSchemas().get(index)));
        }
        super.visitItemSchema(index, itemSchema);
    }

    @Override
    public void visitSchemaOfAdditionalItems(SchemaWrapper schemaOfAdditionalItems) {
        super.visitSchemaOfAdditionalItems(schemaOfAdditionalItems);
    }

    @Override
    public void visitContainedItemSchema(SchemaWrapper containedItemSchema) {
        this.ctx.log("visitContainedItemSchema: " + containedItemSchema);
        DiffContext subCtx = this.ctx.sub("containedItemSchema");
        if (DiffUtil.diffSubschemaAddedRemoved(subCtx, this.original.getContainedItemSchema(), containedItemSchema, DiffType.ARRAY_TYPE_CONTAINED_ITEM_SCHEMA_ADDED, DiffType.ARRAY_TYPE_CONTAINED_ITEM_SCHEMA_REMOVED)) {
            containedItemSchema.accept(new SchemaDiffVisitor(subCtx, this.original.getContainedItemSchema()));
        }
        super.visitContainedItemSchema(containedItemSchema);
    }
}

