/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.canon;

import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.canon.ContentCanonicalizer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Schema;

public class EnhancedAvroContentCanonicalizer
implements ContentCanonicalizer {
    public static final String EMPTY_DOC = "";

    public static Schema normalizeSchema(String schemaString) {
        Schema.Parser parser = new Schema.Parser();
        Schema schema = parser.parse(schemaString);
        return EnhancedAvroContentCanonicalizer.normalizeSchema(schema);
    }

    public static Schema normalizeSchema(Schema schema) {
        return EnhancedAvroContentCanonicalizer.normalizeSchema(schema, new HashMap<String, Boolean>());
    }

    private static Schema normalizeSchema(Schema schema, Map<String, Boolean> alreadyNormalized) {
        Schema result;
        if (schema.getType().equals((Object)Schema.Type.RECORD)) {
            String key = EnhancedAvroContentCanonicalizer.createKey(schema);
            if (alreadyNormalized.containsKey(key)) {
                return schema;
            }
            alreadyNormalized.put(key, true);
        }
        switch (schema.getType()) {
            case RECORD: {
                result = Schema.createRecord((String)schema.getName(), (String)EMPTY_DOC, (String)schema.getNamespace(), (boolean)false, EnhancedAvroContentCanonicalizer.normalizeFields(schema.getFields(), alreadyNormalized));
                break;
            }
            case ENUM: {
                result = Schema.createEnum((String)schema.getName(), (String)EMPTY_DOC, (String)schema.getNamespace(), (List)schema.getEnumSymbols());
                break;
            }
            case ARRAY: {
                result = Schema.createArray((Schema)EnhancedAvroContentCanonicalizer.normalizeSchema(schema.getElementType(), alreadyNormalized));
                break;
            }
            case FIXED: {
                result = Schema.createFixed((String)schema.getName(), (String)EMPTY_DOC, (String)schema.getNamespace(), (int)schema.getFixedSize());
                break;
            }
            case UNION: {
                result = Schema.createUnion(EnhancedAvroContentCanonicalizer.normalizeSchemasList(schema.getTypes(), alreadyNormalized));
                break;
            }
            case MAP: {
                result = Schema.createMap((Schema)EnhancedAvroContentCanonicalizer.normalizeSchema(schema.getValueType()));
                break;
            }
            default: {
                result = Schema.create((Schema.Type)schema.getType());
            }
        }
        schema.getObjectProps().forEach((arg_0, arg_1) -> ((Schema)result).addProp(arg_0, arg_1));
        return result;
    }

    private static List<Schema> normalizeSchemasList(List<Schema> schemas, Map<String, Boolean> alreadyNormalized) {
        ArrayList<Schema> result = new ArrayList<Schema>(schemas.size());
        for (Schema schema : schemas) {
            result.add(EnhancedAvroContentCanonicalizer.normalizeSchema(schema, alreadyNormalized));
        }
        return result;
    }

    private static Schema.Field normalizeField(Schema.Field field, Map<String, Boolean> alreadyNormalized) {
        Schema.Field result = new Schema.Field(field.name(), EnhancedAvroContentCanonicalizer.normalizeSchema(field.schema(), alreadyNormalized), EMPTY_DOC, field.defaultVal(), field.order());
        field.getObjectProps().forEach((arg_0, arg_1) -> ((Schema.Field)result).addProp(arg_0, arg_1));
        return result;
    }

    private static List<Schema.Field> normalizeFields(List<Schema.Field> fields, Map<String, Boolean> alreadyNormalized) {
        ArrayList<Schema.Field> result = new ArrayList<Schema.Field>(fields.size());
        for (Schema.Field field : fields) {
            result.add(EnhancedAvroContentCanonicalizer.normalizeField(field, alreadyNormalized));
        }
        return result;
    }

    private static String createKey(Schema schema) {
        String namespace = EMPTY_DOC;
        try {
            namespace = schema.getNamespace() == null ? EMPTY_DOC : schema.getNamespace();
        }
        catch (AvroRuntimeException avroRuntimeException) {
            // empty catch block
        }
        return namespace + ":" + schema.getName();
    }

    public TypedContent canonicalize(TypedContent content, Map<String, TypedContent> resolvedReferences) {
        String normalisedSchema = EnhancedAvroContentCanonicalizer.normalizeSchema(content.getContent().content()).toString();
        return TypedContent.create((ContentHandle)ContentHandle.create((String)normalisedSchema), (String)"application/json");
    }
}

