/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.refs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.ExternalReference;
import io.apicurio.registry.content.refs.ReferenceFinder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AvroReferenceFinder
implements ReferenceFinder {
    private static final ObjectMapper mapper = new ObjectMapper();
    private static final Logger log = LoggerFactory.getLogger(AvroReferenceFinder.class);
    private static final Set<String> PRIMITIVE_TYPES = Set.of("null", "boolean", "int", "long", "float", "double", "bytes", "string");

    public Set<ExternalReference> findExternalReferences(TypedContent content) {
        try {
            JsonNode tree = mapper.readTree(content.getContent().content());
            HashSet<String> externalTypes = new HashSet<String>();
            AvroReferenceFinder.findExternalTypesIn(tree, externalTypes);
            return externalTypes.stream().map(type -> new ExternalReference(type)).collect(Collectors.toSet());
        }
        catch (Exception e) {
            log.error("Error finding external references in an Avro file.", (Throwable)e);
            return Collections.emptySet();
        }
    }

    private static void findExternalTypesIn(JsonNode schema, Set<String> externalTypes) {
        JsonNode fieldsNode;
        String type;
        if (schema == null || schema.isNull()) {
            return;
        }
        if (schema.isTextual() && !PRIMITIVE_TYPES.contains(type = schema.asText())) {
            externalTypes.add(type);
        }
        if (schema.isArray()) {
            ArrayNode schemas = (ArrayNode)schema;
            schemas.forEach(s -> AvroReferenceFinder.findExternalTypesIn(s, externalTypes));
        }
        if (schema.isObject() && schema.has("type") && !schema.get("type").isNull() && schema.get("type").asText().equals("record") && (fieldsNode = schema.get("fields")) != null && fieldsNode.isArray()) {
            ArrayNode fields = (ArrayNode)fieldsNode;
            fields.forEach(fieldNode -> {
                if (fieldNode.isObject()) {
                    JsonNode typeNode = fieldNode.get("type");
                    AvroReferenceFinder.findExternalTypesIn(typeNode, externalTypes);
                }
            });
        }
        if (schema.has("type") && !schema.get("type").isNull() && schema.get("type").asText().equals("array")) {
            JsonNode items = schema.get("items");
            AvroReferenceFinder.findExternalTypesIn(items, externalTypes);
        }
        if (schema.has("type") && !schema.get("type").isNull() && schema.get("type").asText().equals("map")) {
            JsonNode values = schema.get("values");
            AvroReferenceFinder.findExternalTypesIn(values, externalTypes);
        }
    }
}

