/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rest.v3.beans.ArtifactReference;
import io.apicurio.registry.rules.RuleViolation;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.integrity.IntegrityLevel;
import io.apicurio.registry.rules.validity.ContentValidator;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.types.RuleType;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.avro.AvroTypeException;
import org.apache.avro.Schema;

public class AvroContentValidator
implements ContentValidator {
    private static final String DUMMY_AVRO_RECORD = "{\n     \"type\": \"record\",\n     \"namespace\": \"NAMESPACE\",\n     \"name\": \"NAME\",\n     \"fields\": [\n       { \"name\": \"first\", \"type\": \"string\" },\n       { \"name\": \"last\", \"type\": \"string\" }\n     ]\n}";

    public void validate(ValidityLevel level, TypedContent content, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        if (level == ValidityLevel.SYNTAX_ONLY || level == ValidityLevel.FULL) {
            try {
                Schema.Parser parser = new Schema.Parser();
                for (TypedContent schemaTC : resolvedReferences.values()) {
                    parser.parse(schemaTC.getContent().content());
                }
                parser.parse(content.getContent().content());
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for Avro artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
    }

    public void validateReferences(TypedContent content, List<ArtifactReference> references) throws RuleViolationException {
        try {
            Schema.Parser parser = new Schema.Parser();
            references.forEach(ref -> {
                String refName = ref.getName();
                if (refName != null && refName.contains(".")) {
                    int idx = refName.lastIndexOf(46);
                    String ns = refName.substring(0, idx);
                    String name = refName.substring(idx + 1);
                    parser.parse(DUMMY_AVRO_RECORD.replace("NAMESPACE", ns).replace("NAME", name));
                }
            });
            parser.parse(content.getContent().content());
        }
        catch (AvroTypeException e) {
            if (e.getMessage().startsWith("Undefined schema")) {
                RuleViolation violation = new RuleViolation("Missing reference detected.", e.getMessage());
                throw new RuleViolationException("Missing reference detected in Avro artifact.", RuleType.INTEGRITY, IntegrityLevel.ALL_REFS_MAPPED.name(), Collections.singleton(violation));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

