/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.common;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.pointer.JsonPointer;
import io.vertx.json.schema.SchemaException;
import io.vertx.json.schema.common.BaseCombinatorsValidator;
import io.vertx.json.schema.common.MutableStateValidator;
import io.vertx.json.schema.common.SchemaInternal;
import io.vertx.json.schema.common.SchemaParserInternal;
import io.vertx.json.schema.common.Validator;
import io.vertx.json.schema.common.ValidatorFactory;
import java.util.ArrayList;

public abstract class BaseCombinatorsValidatorFactory
implements ValidatorFactory {
    @Override
    public Validator createValidator(JsonObject schema, JsonPointer scope, SchemaParserInternal parser, MutableStateValidator parent) {
        try {
            JsonArray allOfSchemas = schema.getJsonArray(this.getKeyword());
            if (allOfSchemas.size() == 0) {
                throw new SchemaException(schema, this.getKeyword() + " must have at least one element");
            }
            JsonPointer basePointer = scope.append(this.getKeyword());
            ArrayList<SchemaInternal> parsedSchemas = new ArrayList<SchemaInternal>();
            BaseCombinatorsValidator validator = this.instantiate(parent);
            for (int i = 0; i < allOfSchemas.size(); ++i) {
                parsedSchemas.add(parser.parse(allOfSchemas.getValue(i), basePointer.copy().append(Integer.toString(i)), (MutableStateValidator)validator));
            }
            validator.setSchemas(parsedSchemas);
            return validator;
        }
        catch (ClassCastException e) {
            throw new SchemaException(schema, "Wrong type for " + this.getKeyword() + " keyword", e);
        }
        catch (NullPointerException e) {
            throw new SchemaException(schema, "Null " + this.getKeyword() + " keyword", e);
        }
    }

    @Override
    public boolean canConsumeSchema(JsonObject schema) {
        return schema.containsKey(this.getKeyword());
    }

    abstract BaseCombinatorsValidator instantiate(MutableStateValidator var1);

    abstract String getKeyword();
}

