/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.json.schema.openapi3;

import io.vertx.json.schema.common.BaseFormatValidatorFactory;
import io.vertx.json.schema.common.RegularExpressions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class FormatValidatorFactory
extends BaseFormatValidatorFactory {
    @Override
    protected List<String> initIgnoringFormats() {
        ArrayList<String> formats = new ArrayList<String>(super.initIgnoringFormats());
        formats.add("password");
        return formats;
    }

    @Override
    public Map<String, Predicate<String>> initFormatsMap() {
        HashMap<String, Predicate<String>> predicates = new HashMap<String, Predicate<String>>();
        predicates.put("byte", this.createPredicateFromPattern(RegularExpressions.BASE64));
        predicates.put("date", this.createPredicateFromPattern(RegularExpressions.DATE));
        predicates.put("date-time", this.createPredicateFromPattern(RegularExpressions.DATETIME));
        predicates.put("ipv4", this.createPredicateFromPattern(RegularExpressions.IPV4));
        predicates.put("ipv6", this.createPredicateFromPattern(RegularExpressions.IPV6));
        predicates.put("hostname", this.createPredicateFromPattern(RegularExpressions.HOSTNAME));
        predicates.put("email", this.createPredicateFromPattern(RegularExpressions.EMAIL));
        predicates.put("uri", URI_VALIDATOR);
        predicates.put("uriref", URI_REFERENCE_VALIDATOR);
        predicates.put("uuid", UUID_VALIDATOR);
        return predicates;
    }
}

