/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.rules.validity;

import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.rules.RuleViolationException;
import io.apicurio.registry.rules.validity.ValidityLevel;
import io.apicurio.registry.rules.validity.XmlContentValidator;
import io.apicurio.registry.types.RuleType;
import io.apicurio.registry.util.SchemaFactoryAccessor;
import java.io.InputStream;
import java.util.Map;
import javax.xml.transform.stream.StreamSource;

public class XsdContentValidator
extends XmlContentValidator {
    public void validate(ValidityLevel level, TypedContent content, Map<String, TypedContent> resolvedReferences) throws RuleViolationException {
        super.validate(level, content, resolvedReferences);
        if (level == ValidityLevel.FULL) {
            try (InputStream semanticStream = content.getContent().stream();){
                StreamSource source = new StreamSource(semanticStream);
                SchemaFactoryAccessor.getSchemaFactory().newSchema(source);
            }
            catch (Exception e) {
                throw new RuleViolationException("Syntax violation for XSD Schema artifact.", RuleType.VALIDITY, level.name(), (Throwable)e);
            }
        }
    }
}

