/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.content.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public final class ContentTypeUtil {
    public static final String CT_APPLICATION_JSON = "application/json";
    public static final String CT_APPLICATION_CREATE_EXTENDED = "application/create.extended+json";
    public static final String CT_APPLICATION_GET_EXTENDED = "application/get.extended+json";
    public static final String CT_APPLICATION_YAML = "application/x-yaml";
    public static final String CT_APPLICATION_XML = "application/xml";
    private static final ObjectMapper yamlMapper = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final ObjectMapper jsonMapper = new ObjectMapper();

    public static boolean isApplicationJson(String ct) {
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_JSON);
    }

    public static boolean isApplicationYaml(String ct) {
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_YAML);
    }

    public static boolean isApplicationCreateExtended(String ct) {
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_CREATE_EXTENDED);
    }

    public static boolean isApplicationGetExtended(String ct) {
        if (ct == null) {
            return false;
        }
        return ct.contains(CT_APPLICATION_GET_EXTENDED);
    }

    public static boolean isParsableYaml(ContentHandle yaml) {
        try {
            String content = yaml.content().trim();
            if (content.startsWith("{") || content.startsWith("<")) {
                return false;
            }
            JsonNode root = yamlMapper.readTree(yaml.stream());
            return root != null && root.elements().hasNext();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isParsableJson(ContentHandle content) {
        try {
            JsonNode root = jsonMapper.readTree(content.stream());
            return root != null && !root.isNull() && !root.isMissingNode();
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean isParsableXml(ContentHandle content) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(new InputSource(new StringReader(content.content())), new DefaultHandler());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static ContentHandle yamlToJson(ContentHandle yaml) {
        try {
            JsonNode root = yamlMapper.readTree(yaml.stream());
            return ContentHandle.create(jsonMapper.writerWithDefaultPrettyPrinter().writeValueAsBytes((Object)root));
        }
        catch (Throwable t) {
            return yaml;
        }
    }

    public static JsonNode parseJson(ContentHandle content) throws IOException {
        JsonNode root = jsonMapper.readTree(content.stream());
        return root;
    }

    public static JsonNode parseYaml(ContentHandle content) throws IOException {
        JsonNode root = yamlMapper.readTree(content.stream());
        return root;
    }

    public static JsonNode parseJsonOrYaml(TypedContent content) throws IOException {
        JsonNode node = null;
        String contentType = content.getContentType();
        node = contentType.toLowerCase().contains("yaml") || contentType.toLowerCase().contains("yml") ? ContentTypeUtil.parseYaml(content.getContent()) : ContentTypeUtil.parseJson(content.getContent());
        if (!node.isObject()) {
            throw new IOException("Input is not a valid document.");
        }
        return node;
    }

    public static String determineContentType(ContentHandle content) {
        if (ContentTypeUtil.isParsableJson(content)) {
            return CT_APPLICATION_JSON;
        }
        if (ContentTypeUtil.isParsableYaml(content)) {
            return CT_APPLICATION_YAML;
        }
        if (ContentTypeUtil.isParsableXml(content)) {
            return CT_APPLICATION_XML;
        }
        return "application/x-protobuf";
    }
}

