/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.content.handle;

import io.apicurio.common.apps.content.handle.ContentHandle;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.codec.digest.DigestUtils;

abstract class AbstractContentHandle
implements ContentHandle {
    protected byte[] bytes;
    protected String string;

    AbstractContentHandle() {
    }

    @Override
    public InputStream stream() {
        return new ByteArrayInputStream(this.bytes());
    }

    @Override
    public String string() {
        if (this.string == null) {
            this.string = new String(this.bytes(), StandardCharsets.UTF_8);
        }
        return this.string;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ContentHandle)) {
            return false;
        }
        ContentHandle that = (ContentHandle)o;
        return Arrays.equals(this.bytes(), that.bytes());
    }

    public int hashCode() {
        return Arrays.hashCode(this.bytes());
    }

    @Override
    public int getSizeBytes() {
        return this.bytes().length;
    }

    @Override
    public String getSha256Hash() {
        return DigestUtils.sha256Hex((byte[])this.bytes());
    }
}

