/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.common.apps.content.handle;

import io.apicurio.common.apps.content.IoUtil;
import io.apicurio.common.apps.content.handle.AbstractContentHandle;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.BiConsumer;

class StreamContentHandle
extends AbstractContentHandle {
    private InputStream stream;

    StreamContentHandle(InputStream stream) {
        this.stream = stream;
    }

    @Override
    public InputStream stream() {
        if (this.bytes != null) {
            return new ByteArrayInputStream(this.bytes);
        }
        InputStream is = this.stream;
        this.stream = null;
        return new OnCloseBufferedInputStream(is, (bytes, count) -> {
            byte[] copy = new byte[count.intValue()];
            System.arraycopy(bytes, 0, copy, 0, count);
            this.bytes = copy;
        });
    }

    @Override
    public byte[] bytes() {
        if (this.bytes == null) {
            InputStream is = this.stream;
            this.stream = null;
            this.bytes = IoUtil.toBytes(is);
        }
        return this.bytes;
    }

    private static class OnCloseBufferedInputStream
    extends BufferedInputStream {
        private final BiConsumer<byte[], Integer> onClose;

        private OnCloseBufferedInputStream(InputStream in, BiConsumer<byte[], Integer> onClose) {
            super(in);
            this.onClose = onClose;
        }

        @Override
        public void close() throws IOException {
            this.onClose.accept(this.buf, this.count);
            super.close();
        }
    }
}

