/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.client;

import io.strimzi.kafka.oauth.client.ClientConfig;
import io.strimzi.kafka.oauth.client.metrics.ClientAuthenticationSensorKeyProducer;
import io.strimzi.kafka.oauth.client.metrics.ClientHttpSensorKeyProducer;
import io.strimzi.kafka.oauth.common.Config;
import io.strimzi.kafka.oauth.common.ConfigException;
import io.strimzi.kafka.oauth.common.ConfigUtil;
import io.strimzi.kafka.oauth.common.DeprecationUtil;
import io.strimzi.kafka.oauth.common.FileBasedTokenProvider;
import io.strimzi.kafka.oauth.common.LogUtil;
import io.strimzi.kafka.oauth.common.MetricsHandler;
import io.strimzi.kafka.oauth.common.OAuthAuthenticator;
import io.strimzi.kafka.oauth.common.PrincipalExtractor;
import io.strimzi.kafka.oauth.common.StaticTokenProvider;
import io.strimzi.kafka.oauth.common.TokenInfo;
import io.strimzi.kafka.oauth.common.TokenProvider;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import io.strimzi.kafka.oauth.services.OAuthMetrics;
import io.strimzi.kafka.oauth.services.Services;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Pattern;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.SaslExtensions;
import org.apache.kafka.common.security.auth.SaslExtensionsCallback;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerToken;
import org.apache.kafka.common.security.oauthbearer.OAuthBearerTokenCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JaasClientOauthLoginCallbackHandler
implements AuthenticateCallbackHandler {
    private static final Logger LOG = LoggerFactory.getLogger(JaasClientOauthLoginCallbackHandler.class);
    private ClientConfig config = new ClientConfig();
    private String clientId;
    private String clientSecret;
    private String clientAssertionType;
    private TokenProvider tokenProvider;
    private TokenProvider refreshTokenProvider;
    private TokenProvider clientAssertionProvider;
    private String username;
    private String password;
    private String scope;
    private String audience;
    private URI tokenEndpoint;
    private boolean isJwt;
    private int maxTokenExpirySeconds;
    private PrincipalExtractor principalExtractor;
    private SSLSocketFactory socketFactory;
    private HostnameVerifier hostnameVerifier;
    private int connectTimeout;
    private int readTimeout;
    private int retries;
    private long retryPauseMillis;
    private boolean enableMetrics;
    private OAuthMetrics metrics;
    private SensorKeyProducer authSensorKeyProducer;
    private SensorKeyProducer tokenSensorKeyProducer;
    private final ClientMetricsHandler authenticatorMetrics = new ClientMetricsHandler();
    private boolean includeAcceptHeader;
    private final Map<String, String> saslExtensions = new LinkedHashMap<String, String>();
    private static final Pattern SASL_KEY_VALIDATION_PATTERN = Pattern.compile("[A-Za-z]+");
    private static final Pattern SASL_VALUE_VALIDATION_PATTERN = Pattern.compile("[\\x21-\\x7E \t\r\n]+");

    public void configure(Map<String, ?> configs, String saslMechanism, List<AppConfigurationEntry> jaasConfigEntries) {
        if (!"OAUTHBEARER".equals(saslMechanism)) {
            throw new IllegalArgumentException("Unexpected SASL mechanism: " + saslMechanism);
        }
        Map<Object, Object> options = Collections.emptyMap();
        if (!jaasConfigEntries.isEmpty()) {
            options = jaasConfigEntries.get(0).getOptions();
            Properties p = new Properties();
            p.putAll(options);
            this.config = new ClientConfig(p);
        }
        String token = this.config.getValue("oauth.access.token");
        String tokenLocation = this.config.getValue("oauth.access.token.location");
        this.tokenProvider = this.configureAccessTokenProvider(token, tokenLocation);
        if (token == null && tokenLocation == null) {
            String endpoint = this.config.getValue("oauth.token.endpoint.uri");
            if (endpoint == null) {
                throw new ConfigException("Access token not specified ('oauth.access.token' or 'oauth.access.token.location'). OAuth token endpoint ('oauth.token.endpoint.uri') should then be set.");
            }
            try {
                this.tokenEndpoint = new URI(endpoint);
            }
            catch (URISyntaxException e) {
                throw new ConfigException("Specified token endpoint uri is invalid ('oauth.token.endpoint.uri'): " + endpoint, (Throwable)e);
            }
        }
        String refreshToken = this.config.getValue("oauth.refresh.token");
        String refreshTokenLocation = this.config.getValue("oauth.refresh.token.location");
        this.refreshTokenProvider = this.configureRefreshTokenProvider(refreshToken, refreshTokenLocation);
        this.clientId = this.config.getValue("oauth.client.id");
        this.clientSecret = this.config.getValue("oauth.client.secret");
        String clientAssertion = this.config.getValue("oauth.client.assertion");
        String clientAssertionLocation = this.config.getValue("oauth.client.assertion.location");
        this.clientAssertionProvider = this.configureClientAssertionTokenProvider(clientAssertion, clientAssertionLocation);
        this.clientAssertionType = this.config.getValue("oauth.client.assertion.type", "urn:ietf:params:oauth:client-assertion-type:jwt-bearer");
        this.username = this.config.getValue("oauth.password.grant.username");
        this.password = this.config.getValue("oauth.password.grant.password");
        this.scope = this.config.getValue("oauth.scope");
        this.audience = this.config.getValue("oauth.audience");
        this.socketFactory = ConfigUtil.createSSLFactory((Config)this.config);
        this.hostnameVerifier = ConfigUtil.createHostnameVerifier((Config)this.config);
        this.connectTimeout = ConfigUtil.getConnectTimeout((Config)this.config);
        this.readTimeout = ConfigUtil.getReadTimeout((Config)this.config);
        this.retries = this.getHttpRetries(this.config);
        this.retryPauseMillis = this.getHttpRetryPauseMillis(this.config, this.retries);
        this.includeAcceptHeader = this.config.getValueAsBoolean("oauth.include.accept.header", true);
        this.checkConfiguration();
        this.principalExtractor = new PrincipalExtractor(this.config.getValue("oauth.username.claim"), this.config.getValue("oauth.username.prefix"), this.config.getValue("oauth.fallback.username.claim"), this.config.getValue("oauth.fallback.username.prefix"));
        this.isJwt = DeprecationUtil.isAccessTokenJwt((Config)this.config, (Logger)LOG, null);
        if (!this.isJwt && this.principalExtractor.isConfigured()) {
            LOG.warn("Token is not JWT ('{}' is 'false') - custom username claim configuration will be ignored ('{}', '{}', '{}', '{}')", new Object[]{"oauth.access.token.is.jwt", "oauth.username.claim", "oauth.username.prefix", "oauth.fallback.username.claim", "oauth.fallback.username.prefix"});
        }
        this.maxTokenExpirySeconds = this.config.getValueAsInt("oauth.max.token.expiry.seconds", -1);
        if (this.maxTokenExpirySeconds > 0 && this.maxTokenExpirySeconds < 60) {
            throw new ConfigException("Invalid value configured for 'oauth.max.token.expiry.seconds': " + this.maxTokenExpirySeconds + " (should be at least 60)");
        }
        String configId = this.configureMetrics(configs);
        for (String string : options.keySet()) {
            if (!string.startsWith("oauth.sasl.extension.")) continue;
            String value = this.config.getValue(string, "");
            String string2 = string.substring("oauth.sasl.extension.".length());
            this.validateSaslExtension(string2, value);
            this.saslExtensions.put(string2, value);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Configured JaasClientOauthLoginCallbackHandler:\n    configId: " + configId + "\n    token: " + LogUtil.mask((String)token) + "\n    tokenLocation: " + tokenLocation + "\n    refreshToken: " + LogUtil.mask((String)refreshToken) + "\n    refreshTokenLocation: " + refreshTokenLocation + "\n    tokenEndpointUri: " + this.tokenEndpoint + "\n    clientId: " + this.clientId + "\n    clientSecret: " + LogUtil.mask((String)this.clientSecret) + "\n    clientAssertion: " + LogUtil.mask((String)clientAssertion) + "\n    clientAssertionLocation: " + clientAssertionLocation + "\n    clientAssertionType: " + this.clientAssertionType + "\n    username: " + this.username + "\n    password: " + LogUtil.mask((String)this.password) + "\n    scope: " + this.scope + "\n    audience: " + this.audience + "\n    isJwt: " + this.isJwt + "\n    maxTokenExpirySeconds: " + this.maxTokenExpirySeconds + "\n    principalExtractor: " + this.principalExtractor + "\n    connectTimeout: " + this.connectTimeout + "\n    readTimeout: " + this.readTimeout + "\n    retries: " + this.retries + "\n    retryPauseMillis: " + this.retryPauseMillis + "\n    enableMetrics: " + this.enableMetrics + "\n    includeAcceptHeader: " + this.includeAcceptHeader + "\n    saslExtensions: " + this.saslExtensions);
        }
    }

    private void validateSaslExtension(String key, String value) {
        if (!SASL_KEY_VALIDATION_PATTERN.matcher(key).matches() || "auth".equals(key)) {
            throw new ConfigException("Invalid sasl extension key: '" + key + "' ('" + "oauth.sasl.extension." + key + "')");
        }
        if (!SASL_VALUE_VALIDATION_PATTERN.matcher(value).matches()) {
            throw new ConfigException("Invalid sasl extension value for key: '" + key + "' ('" + "oauth.sasl.extension." + key + "')");
        }
    }

    private TokenProvider configureAccessTokenProvider(String token, String tokenLocation) {
        String tokenIgnoredMessage = "Access token location is configured ('oauth.access.token.location'), access token will be ignored ('oauth.access.token').";
        String noSuchFileMessage = "Specified access token location is invalid ('oauth.access.token.location')";
        return this.configureAnyTokenProvider(token, tokenLocation, tokenIgnoredMessage, noSuchFileMessage);
    }

    private TokenProvider configureRefreshTokenProvider(String token, String tokenLocation) {
        String tokenIgnoredMessage = "Refresh token location is configured ('oauth.refresh.token.location'), refresh token will be ignored ('oauth.refresh.token').";
        String noSuchFileMessage = "Specified refresh token location is invalid ('oauth.refresh.token.location')";
        return this.configureAnyTokenProvider(token, tokenLocation, tokenIgnoredMessage, noSuchFileMessage);
    }

    private TokenProvider configureClientAssertionTokenProvider(String token, String tokenLocation) {
        String tokenIgnoredMessage = "Client assertion location is configured ('oauth.client.assertion.location'), client assertion will be ignored ('oauth.client.assertion').";
        String noSuchFileMessage = "Specified client assertion location is invalid ('oauth.client.assertion.location')";
        return this.configureAnyTokenProvider(token, tokenLocation, tokenIgnoredMessage, noSuchFileMessage);
    }

    private TokenProvider configureAnyTokenProvider(String token, String tokenLocation, String tokenIgnoredMessage, String noSuchFileMessage) {
        if (tokenLocation != null) {
            try {
                if (token != null) {
                    LOG.warn(tokenIgnoredMessage);
                }
                return new FileBasedTokenProvider(tokenLocation);
            }
            catch (IllegalArgumentException e) {
                throw new ConfigException(noSuchFileMessage + ": " + e.getMessage());
            }
        }
        if (token != null) {
            return new StaticTokenProvider(token);
        }
        return null;
    }

    private int getHttpRetries(ClientConfig config) {
        int retries = config.getValueAsInt("oauth.http.retries", 0);
        if (retries < 0) {
            throw new ConfigException("The configured value of 'oauth.http.retries' has to be greater or equal to zero");
        }
        return retries;
    }

    private long getHttpRetryPauseMillis(ClientConfig config, int retries) {
        long retryPauseMillis = config.getValueAsLong("oauth.http.retry.pause.millis", 0L);
        if (retries > 0) {
            if (retryPauseMillis < 0L) {
                retryPauseMillis = 0L;
                LOG.warn("The configured value of '{}' is less than zero and will be ignored", (Object)"oauth.http.retry.pause.millis");
            }
            if (retryPauseMillis <= 0L) {
                LOG.warn("No pause between http retries configured. Consider setting '{}' to greater than zero to avoid flooding the authorization server with requests.", (Object)"oauth.http.retry.pause.millis");
            }
        }
        return retryPauseMillis;
    }

    private void checkConfiguration() {
        if (this.tokenProvider != null) {
            if (this.refreshTokenProvider != null) {
                LOG.warn("Access token is configured ('{}'), refresh token will be ignored ('{}', '{}').", new Object[]{"oauth.access.token", "oauth.refresh.token", "oauth.refresh.token.location"});
            }
            if (this.username != null) {
                LOG.warn("Access token is configured ('{}'), username will be ignored ('{}').", (Object)"oauth.access.token", (Object)"oauth.password.grant.username");
            }
            if (this.clientId != null) {
                LOG.warn("Access token is configured ('{}'), client id will be ignored ('{}').", (Object)"oauth.access.token", (Object)"oauth.client.id");
            }
            if (this.clientAssertionProvider != null) {
                LOG.warn("Access token is configured ('{}'), client assertion (location) will be ignored ('{}', '{}').", new Object[]{"oauth.access.token", "oauth.client.assertion", "oauth.client.assertion.location"});
            }
        } else if (this.refreshTokenProvider != null && this.username != null) {
            LOG.warn("Refresh token is configured ('{}'), username will be ignored ('{}').", (Object)"oauth.refresh.token", (Object)"oauth.password.grant.username");
        }
        if (this.tokenProvider == null) {
            if (this.clientId == null) {
                throw new ConfigException("No client id specified ('oauth.client.id')");
            }
            if (this.username != null && this.password == null) {
                throw new ConfigException("Username configured ('oauth.password.grant.username') but no password specified ('oauth.password.grant.password')");
            }
            if (this.refreshTokenProvider == null && this.clientSecret == null && this.username == null && this.clientAssertionProvider == null) {
                throw new ConfigException("No access token or location ('oauth.access.token', 'oauth.access.token.location'), refresh token or location ('oauth.refresh.token', 'oauth.refresh.token.location'), client credentials ('oauth.client.secret'), user credentials ('oauth.password.grant.username') or clientAssertion or location ('oauth.client.assertion', 'oauth.client.assertion.location') specified");
            }
        }
    }

    private String configureMetrics(Map<String, ?> configs) {
        String configId = this.config.getValue("oauth.config.id", "client");
        this.enableMetrics = this.config.getValueAsBoolean("oauth.enable.metrics", false);
        this.authSensorKeyProducer = new ClientAuthenticationSensorKeyProducer(configId, this.tokenEndpoint);
        ClientHttpSensorKeyProducer clientHttpSensorKeyProducer = this.tokenSensorKeyProducer = this.tokenEndpoint != null ? new ClientHttpSensorKeyProducer(configId, this.tokenEndpoint) : null;
        if (!Services.isAvailable()) {
            Services.configure(configs);
        }
        if (this.enableMetrics) {
            this.metrics = Services.getInstance().getMetrics();
        }
        return configId;
    }

    public void close() {
    }

    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof OAuthBearerTokenCallback) {
                this.handleCallback((OAuthBearerTokenCallback)callback);
                continue;
            }
            if (callback instanceof SaslExtensionsCallback) {
                this.handleExtensionsCallback((SaslExtensionsCallback)callback);
                continue;
            }
            throw new UnsupportedCallbackException(callback);
        }
    }

    private void handleExtensionsCallback(SaslExtensionsCallback callback) {
        SaslExtensions extensions = new SaslExtensions(this.saslExtensions);
        callback.extensions(extensions);
    }

    private void handleCallback(OAuthBearerTokenCallback callback) throws IOException {
        TokenInfo result;
        if (callback.token() != null) {
            throw new IllegalArgumentException("Callback had a token already");
        }
        long requestStartTime = System.currentTimeMillis();
        try {
            if (this.tokenProvider != null) {
                result = OAuthAuthenticator.loginWithAccessToken((String)this.tokenProvider.token(), (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor);
            } else if (this.refreshTokenProvider != null) {
                result = OAuthAuthenticator.loginWithRefreshToken((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.refreshTokenProvider.token(), (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else if (this.username != null) {
                result = OAuthAuthenticator.loginWithPassword((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.username, (String)this.password, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else if (this.clientSecret != null) {
                result = OAuthAuthenticator.loginWithClientSecret((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.clientId, (String)this.clientSecret, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else if (this.clientAssertionProvider != null) {
                result = OAuthAuthenticator.loginWithClientAssertion((URI)this.tokenEndpoint, (SSLSocketFactory)this.socketFactory, (HostnameVerifier)this.hostnameVerifier, (String)this.clientId, (String)this.clientAssertionProvider.token(), (String)this.clientAssertionType, (boolean)this.isJwt, (PrincipalExtractor)this.principalExtractor, (String)this.scope, (String)this.audience, (int)this.connectTimeout, (int)this.readTimeout, (MetricsHandler)this.authenticatorMetrics, (int)this.retries, (long)this.retryPauseMillis, (boolean)this.includeAcceptHeader);
            } else {
                throw new IllegalStateException("Invalid oauth client configuration - no credentials");
            }
            this.addSuccessTime(requestStartTime);
        }
        catch (Throwable t) {
            this.addErrorTime(t, requestStartTime);
            throw t;
        }
        final TokenInfo finalResult = result;
        callback.token(new OAuthBearerToken(){

            public String value() {
                return finalResult.token();
            }

            public Set<String> scope() {
                return finalResult.scope();
            }

            public long lifetimeMs() {
                long maxExpiresAt = finalResult.issuedAtMs() + (long)JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds * 1000L;
                if (JaasClientOauthLoginCallbackHandler.this.maxTokenExpirySeconds > 0 && finalResult.expiresAtMs() > maxExpiresAt) {
                    return maxExpiresAt;
                }
                return finalResult.expiresAtMs();
            }

            public String principalName() {
                return finalResult.principal();
            }

            public Long startTimeMs() {
                return finalResult.issuedAtMs();
            }
        });
    }

    private void addSuccessTime(long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.authSensorKeyProducer.successKey(), System.currentTimeMillis() - startTimeMs);
        }
    }

    private void addErrorTime(Throwable e, long startTimeMs) {
        if (this.enableMetrics) {
            this.metrics.addTime(this.authSensorKeyProducer.errorKey(e), System.currentTimeMillis() - startTimeMs);
        }
    }

    class ClientMetricsHandler
    implements MetricsHandler {
        ClientMetricsHandler() {
        }

        public void addSuccessRequestTime(long millis) {
            if (JaasClientOauthLoginCallbackHandler.this.enableMetrics) {
                JaasClientOauthLoginCallbackHandler.this.metrics.addTime(JaasClientOauthLoginCallbackHandler.this.tokenSensorKeyProducer.successKey(), millis);
            }
        }

        public void addErrorRequestTime(Throwable e, long millis) {
            if (JaasClientOauthLoginCallbackHandler.this.enableMetrics) {
                JaasClientOauthLoginCallbackHandler.this.metrics.addTime(JaasClientOauthLoginCallbackHandler.this.tokenSensorKeyProducer.errorKey(e), millis);
            }
        }
    }
}

