/*
 * Decompiled with CFR 0.152.
 */
package io.strimzi.kafka.oauth.client.metrics;

import io.strimzi.kafka.oauth.metrics.MetricsUtil;
import io.strimzi.kafka.oauth.metrics.SensorKey;
import io.strimzi.kafka.oauth.metrics.SensorKeyProducer;
import java.net.URI;
import java.util.Map;

public class ClientAuthenticationSensorKeyProducer
implements SensorKeyProducer {
    private final String contextId;
    private final URI uri;

    public ClientAuthenticationSensorKeyProducer(String contextId, URI uri) {
        if (contextId == null) {
            throw new IllegalArgumentException("contextId == null");
        }
        this.contextId = contextId;
        this.uri = uri;
    }

    public SensorKey successKey() {
        Map attrs = MetricsUtil.getSensorKeyAttrs((String)this.contextId, (URI)this.uri, (String)"client-auth");
        attrs.put("outcome", "success");
        return SensorKey.of((String)"authentication_requests", (Map)attrs);
    }

    public SensorKey errorKey(Throwable e) {
        Map attrs = MetricsUtil.getSensorKeyAttrs((String)this.contextId, (URI)this.uri, (String)"client-auth");
        attrs.put("outcome", "error");
        attrs.put("error_type", "other");
        return SensorKey.of((String)"authentication_requests", (Map)attrs);
    }
}

