/*
 * Decompiled with CFR 0.152.
 */
package graphql.parser;

import graphql.Assert;
import graphql.PublicApi;
import graphql.i18n.I18n;
import graphql.parser.ParserOptions;
import java.io.Reader;
import java.io.StringReader;
import java.util.Locale;

@PublicApi
public interface ParserEnvironment {
    public Reader getDocument();

    public ParserOptions getParserOptions();

    public Locale getLocale();

    public I18n getI18N();

    public static Builder newParserEnvironment() {
        return new Builder();
    }

    public static class Builder {
        Reader reader;
        ParserOptions parserOptions = ParserOptions.getDefaultParserOptions();
        Locale locale = Locale.getDefault();

        public Builder document(Reader documentText) {
            this.reader = Assert.assertNotNull(documentText);
            return this;
        }

        public Builder document(String documentText) {
            return this.document(new StringReader(documentText));
        }

        public Builder parserOptions(ParserOptions parserOptions) {
            this.parserOptions = parserOptions;
            return this;
        }

        public Builder locale(Locale locale) {
            this.locale = Assert.assertNotNull(locale);
            return this;
        }

        public ParserEnvironment build() {
            final I18n i18n = I18n.i18n(I18n.BundleType.Parsing, this.locale);
            return new ParserEnvironment(){

                @Override
                public Reader getDocument() {
                    return reader;
                }

                @Override
                public ParserOptions getParserOptions() {
                    return parserOptions;
                }

                @Override
                public Locale getLocale() {
                    return locale;
                }

                @Override
                public I18n getI18N() {
                    return i18n;
                }
            };
        }
    }
}

