/*
 * Decompiled with CFR 0.152.
 */
package graphql.schema.idl;

import graphql.GraphQLError;
import graphql.PublicApi;
import graphql.language.OperationTypeDefinition;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLDirective;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.idl.RuntimeWiring;
import graphql.schema.idl.SchemaDirectiveWiringSchemaGeneratorPostProcessing;
import graphql.schema.idl.SchemaExtensionsChecker;
import graphql.schema.idl.SchemaGeneratorHelper;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.SchemaTypeChecker;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.errors.SchemaProblem;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class SchemaGenerator {
    private final SchemaTypeChecker typeChecker = new SchemaTypeChecker();
    private final SchemaGeneratorHelper schemaGeneratorHelper = new SchemaGeneratorHelper();

    public static GraphQLSchema createdMockedSchema(String sdl) {
        TypeDefinitionRegistry typeDefinitionRegistry = new SchemaParser().parse(sdl);
        GraphQLSchema graphQLSchema = new SchemaGenerator().makeExecutableSchema(typeDefinitionRegistry, RuntimeWiring.MOCKED_WIRING);
        return graphQLSchema;
    }

    public GraphQLSchema makeExecutableSchema(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        return this.makeExecutableSchema(Options.defaultOptions(), typeRegistry, wiring);
    }

    public GraphQLSchema makeExecutableSchema(Options options, TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring) throws SchemaProblem {
        TypeDefinitionRegistry typeRegistryCopy = new TypeDefinitionRegistry();
        typeRegistryCopy.merge(typeRegistry);
        this.schemaGeneratorHelper.addDirectivesIncludedByDefault(typeRegistryCopy);
        List<GraphQLError> errors = this.typeChecker.checkTypeRegistry(typeRegistryCopy, wiring);
        if (!errors.isEmpty()) {
            throw new SchemaProblem(errors);
        }
        Map<String, OperationTypeDefinition> operationTypeDefinitions = SchemaExtensionsChecker.gatherOperationDefs(typeRegistry);
        return this.makeExecutableSchemaImpl(typeRegistryCopy, wiring, operationTypeDefinitions, options);
    }

    private GraphQLSchema makeExecutableSchemaImpl(TypeDefinitionRegistry typeRegistry, RuntimeWiring wiring, Map<String, OperationTypeDefinition> operationTypeDefinitions, Options options) {
        SchemaGeneratorHelper.BuildContext buildCtx = new SchemaGeneratorHelper.BuildContext(typeRegistry, wiring, operationTypeDefinitions, options);
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        Set<GraphQLDirective> additionalDirectives = this.schemaGeneratorHelper.buildAdditionalDirectiveDefinitions(buildCtx);
        schemaBuilder.additionalDirectives(additionalDirectives);
        this.schemaGeneratorHelper.buildSchemaDirectivesAndExtensions(buildCtx, schemaBuilder);
        this.schemaGeneratorHelper.buildOperations(buildCtx, schemaBuilder);
        Set<GraphQLType> additionalTypes = this.schemaGeneratorHelper.buildAdditionalTypes(buildCtx);
        schemaBuilder.additionalTypes(additionalTypes);
        buildCtx.getCodeRegistry().fieldVisibility(buildCtx.getWiring().getFieldVisibility());
        GraphQLCodeRegistry codeRegistry = buildCtx.getCodeRegistry().build();
        schemaBuilder.codeRegistry(codeRegistry);
        buildCtx.getTypeRegistry().schemaDefinition().ifPresent(schemaDefinition -> {
            String description = SchemaGeneratorHelper.buildDescription(buildCtx, schemaDefinition, schemaDefinition.getDescription());
            schemaBuilder.description(description);
        });
        GraphQLSchema graphQLSchema = schemaBuilder.build();
        if (buildCtx.isDirectiveWiringRequired()) {
            SchemaDirectiveWiringSchemaGeneratorPostProcessing directiveWiringProcessing = new SchemaDirectiveWiringSchemaGeneratorPostProcessing(buildCtx.getTypeRegistry(), buildCtx.getWiring(), buildCtx.getCodeRegistry());
            graphQLSchema = directiveWiringProcessing.process(graphQLSchema);
        }
        return graphQLSchema;
    }

    public static class Options {
        private final boolean useCommentsAsDescription;
        private final boolean captureAstDefinitions;
        private final boolean useAppliedDirectivesOnly;

        Options(boolean useCommentsAsDescription, boolean captureAstDefinitions, boolean useAppliedDirectivesOnly) {
            this.useCommentsAsDescription = useCommentsAsDescription;
            this.captureAstDefinitions = captureAstDefinitions;
            this.useAppliedDirectivesOnly = useAppliedDirectivesOnly;
        }

        public boolean isUseCommentsAsDescription() {
            return this.useCommentsAsDescription;
        }

        public boolean isCaptureAstDefinitions() {
            return this.captureAstDefinitions;
        }

        public boolean isUseAppliedDirectivesOnly() {
            return this.useAppliedDirectivesOnly;
        }

        public static Options defaultOptions() {
            return new Options(true, true, false);
        }

        public Options useCommentsAsDescriptions(boolean useCommentsAsDescription) {
            return new Options(useCommentsAsDescription, this.captureAstDefinitions, this.useAppliedDirectivesOnly);
        }

        public Options captureAstDefinitions(boolean captureAstDefinitions) {
            return new Options(this.useCommentsAsDescription, captureAstDefinitions, this.useAppliedDirectivesOnly);
        }

        public Options useAppliedDirectivesOnly(boolean useAppliedDirectivesOnly) {
            return new Options(this.useCommentsAsDescription, this.captureAstDefinitions, useAppliedDirectivesOnly);
        }
    }
}

