/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.impl;

import io.netty.channel.EventLoop;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.ThreadingModel;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextBase;
import io.vertx.core.impl.ContextImpl;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.Deployment;
import io.vertx.core.impl.TaskQueue;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.WorkerPool;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.tracing.VertxTracer;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;

final class DuplicatedContext
extends ContextBase
implements ContextInternal {
    final ContextImpl delegate;

    DuplicatedContext(ContextImpl delegate) {
        super(delegate);
        this.delegate = delegate;
    }

    public ThreadingModel threadingModel() {
        return this.delegate.threadingModel();
    }

    public boolean inThread() {
        return this.delegate.inThread();
    }

    public final CloseFuture closeFuture() {
        return this.delegate.closeFuture();
    }

    public final VertxTracer tracer() {
        return this.delegate.tracer();
    }

    public final JsonObject config() {
        return this.delegate.config();
    }

    public final Context exceptionHandler(Handler<Throwable> handler) {
        this.delegate.exceptionHandler(handler);
        return this;
    }

    public Executor executor() {
        return this.delegate.executor();
    }

    public final Handler<Throwable> exceptionHandler() {
        return this.delegate.exceptionHandler();
    }

    public final EventLoop nettyEventLoop() {
        return this.delegate.nettyEventLoop();
    }

    public final Deployment getDeployment() {
        return this.delegate.getDeployment();
    }

    public final VertxInternal owner() {
        return this.delegate.owner();
    }

    public final ClassLoader classLoader() {
        return this.delegate.classLoader();
    }

    public WorkerPool workerPool() {
        return this.delegate.workerPool();
    }

    public final void reportException(Throwable t) {
        this.delegate.reportException(t);
    }

    public final ConcurrentMap<Object, Object> contextData() {
        return this.delegate.contextData();
    }

    public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.delegate.internalWorkerPool, this.delegate.internalOrderedTasks);
    }

    public <T> Future<T> executeBlockingInternal(Callable<T> action) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.delegate.internalWorkerPool, this.delegate.internalOrderedTasks);
    }

    public final <T> Future<T> executeBlockingInternal(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.delegate.internalWorkerPool, ordered ? this.delegate.internalOrderedTasks : null);
    }

    public <T> Future<T> executeBlockingInternal(Callable<T> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.delegate.internalWorkerPool, ordered ? this.delegate.internalOrderedTasks : null);
    }

    public final <T> Future<T> executeBlocking(Handler<Promise<T>> action, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, action, this.delegate.workerPool, ordered ? this.delegate.orderedTasks : null);
    }

    public final <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, boolean ordered) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.delegate.workerPool, ordered ? this.delegate.orderedTasks : null);
    }

    public final <T> Future<T> executeBlocking(Handler<Promise<T>> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.delegate.workerPool, queue);
    }

    public final <T> Future<T> executeBlocking(Callable<T> blockingCodeHandler, TaskQueue queue) {
        return ContextImpl.executeBlocking((ContextInternal)this, blockingCodeHandler, this.delegate.workerPool, queue);
    }

    public final <T> void execute(T argument, Handler<T> task) {
        this.delegate.execute(this, argument, task);
    }

    public <T> void emit(T argument, Handler<T> task) {
        this.delegate.emit(this, argument, task);
    }

    public void execute(Runnable task) {
        this.delegate.execute(this, task);
    }

    public boolean isEventLoopContext() {
        return this.delegate.isEventLoopContext();
    }

    public boolean isWorkerContext() {
        return this.delegate.isWorkerContext();
    }

    public ContextInternal duplicate() {
        return new DuplicatedContext(this.delegate);
    }

    public ContextInternal unwrap() {
        return this.delegate;
    }

    public boolean isDuplicate() {
        return true;
    }
}

