/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.core.shareddata.impl;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.shareddata.AsyncMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class LocalAsyncMapImpl<K, V>
implements AsyncMap<K, V> {
    private final VertxInternal vertx;
    private final ConcurrentMap<K, Holder<V>> map;

    public LocalAsyncMapImpl(VertxInternal vertx) {
        this.vertx = vertx;
        this.map = new ConcurrentHashMap<K, Holder<V>>();
    }

    @Override
    public Future<V> get(K k) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder h = (Holder)this.map.get(k);
        if (h != null && h.hasNotExpired()) {
            return ctx.succeededFuture(h.value);
        }
        return ctx.succeededFuture();
    }

    @Override
    public Future<Void> put(K k, V v) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder<V> previous = this.map.put(k, new Holder<V>(v));
        if (previous != null && previous.expires()) {
            this.vertx.cancelTimer(previous.timerId);
        }
        return ctx.succeededFuture();
    }

    @Override
    public Future<V> putIfAbsent(K k, V v) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder<V> h = this.map.putIfAbsent(k, new Holder<V>(v));
        return ctx.succeededFuture(h == null ? null : h.value);
    }

    @Override
    public Future<Void> put(K k, V v, long ttl) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(ttl, l -> this.removeIfExpired(k));
        Holder<V> previous = this.map.put(k, new Holder<V>(v, timerId, ttl, timestamp));
        if (previous != null && previous.expires()) {
            this.vertx.cancelTimer(previous.timerId);
        }
        return ctx.succeededFuture();
    }

    private void removeIfExpired(K k) {
        this.map.computeIfPresent(k, (key, holder) -> holder.hasNotExpired() ? holder : null);
    }

    @Override
    public Future<V> putIfAbsent(K k, V v, long ttl) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(ttl, l -> this.removeIfExpired(k));
        Holder<V> existing = this.map.putIfAbsent(k, new Holder<V>(v, timerId, ttl, timestamp));
        if (existing != null) {
            this.vertx.cancelTimer(timerId);
            return ctx.succeededFuture(existing.value);
        }
        return ctx.succeededFuture();
    }

    @Override
    public Future<Boolean> removeIfPresent(K k, V v) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        AtomicBoolean result = new AtomicBoolean();
        this.map.computeIfPresent(k, (key, holder) -> {
            if (holder.value.equals(v)) {
                result.compareAndSet(false, true);
                if (holder.expires()) {
                    this.vertx.cancelTimer(holder.timerId);
                }
                return null;
            }
            return holder;
        });
        return ctx.succeededFuture((Object)result.get());
    }

    @Override
    public Future<V> replace(K k, V v) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder<V> previous = this.map.replace(k, new Holder<V>(v));
        if (previous != null) {
            if (previous.expires()) {
                this.vertx.cancelTimer(previous.timerId);
            }
            return ctx.succeededFuture(previous.value);
        }
        return ctx.succeededFuture();
    }

    @Override
    public Future<V> replace(K k, V v, long ttl) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(ttl, l -> this.removeIfExpired(k));
        Holder<V> previous = this.map.replace(k, new Holder<V>(v, timerId, ttl, timestamp));
        if (previous != null) {
            if (previous.expires()) {
                this.vertx.cancelTimer(previous.timerId);
            }
            return ctx.succeededFuture(previous.value);
        }
        return ctx.succeededFuture();
    }

    @Override
    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder<V> h = new Holder<V>(newValue);
        Holder result = this.map.computeIfPresent(k, (key, holder) -> {
            if (holder.value.equals(oldValue)) {
                if (holder.expires()) {
                    this.vertx.cancelTimer(holder.timerId);
                }
                return h;
            }
            return holder;
        });
        return ctx.succeededFuture((Object)(h == result ? 1 : 0));
    }

    @Override
    public Future<Boolean> replaceIfPresent(K k, V oldValue, V newValue, long ttl) {
        Holder result;
        ContextInternal ctx = this.vertx.getOrCreateContext();
        long timestamp = System.nanoTime();
        long timerId = this.vertx.setTimer(ttl, l -> this.removeIfExpired(k));
        Holder<V> h = new Holder<V>(newValue, timerId, ttl, timestamp);
        if (h == (result = this.map.computeIfPresent(k, (key, holder) -> {
            if (holder.value.equals(oldValue)) {
                if (holder.expires()) {
                    this.vertx.cancelTimer(holder.timerId);
                }
                return h;
            }
            return holder;
        }))) {
            return ctx.succeededFuture((Object)true);
        }
        this.vertx.cancelTimer(timerId);
        return ctx.succeededFuture((Object)false);
    }

    @Override
    public Future<Void> clear() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        this.map.clear();
        return ctx.succeededFuture();
    }

    @Override
    public Future<Integer> size() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.succeededFuture((Object)this.map.size());
    }

    @Override
    public Future<Set<K>> keys() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        return ctx.succeededFuture(new HashSet(this.map.keySet()));
    }

    @Override
    public Future<List<V>> values() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        List result = this.map.values().stream().filter(Holder::hasNotExpired).map(h -> h.value).collect(Collectors.toList());
        return ctx.succeededFuture(result);
    }

    @Override
    public Future<Map<K, V>> entries() {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        HashMap result = new HashMap(this.map.size());
        this.map.forEach((key, holder) -> {
            if (holder.hasNotExpired()) {
                result.put(key, holder.value);
            }
        });
        return ctx.succeededFuture(result);
    }

    @Override
    public Future<V> remove(K k) {
        ContextInternal ctx = this.vertx.getOrCreateContext();
        Holder previous = (Holder)this.map.remove(k);
        if (previous != null) {
            if (previous.expires()) {
                this.vertx.cancelTimer(previous.timerId);
            }
            return ctx.succeededFuture(previous.value);
        }
        return ctx.succeededFuture();
    }

    private static class Holder<V> {
        final V value;
        final long timerId;
        final long ttl;
        final long timestamp;

        Holder(V value) {
            Objects.requireNonNull(value);
            this.value = value;
            this.timerId = 0L;
            this.ttl = 0L;
            this.timestamp = 0L;
        }

        Holder(V value, long timerId, long ttl, long timestamp) {
            Objects.requireNonNull(value);
            if (ttl < 1L) {
                throw new IllegalArgumentException("ttl must be positive: " + ttl);
            }
            this.value = value;
            this.timerId = timerId;
            this.ttl = ttl;
            this.timestamp = timestamp;
        }

        boolean expires() {
            return this.ttl > 0L;
        }

        boolean hasNotExpired() {
            return !this.expires() || TimeUnit.MILLISECONDS.convert(System.nanoTime() - this.timestamp, TimeUnit.NANOSECONDS) < this.ttl;
        }

        public String toString() {
            return "Holder{value=" + this.value + ", timerId=" + this.timerId + ", ttl=" + this.ttl + ", timestamp=" + this.timestamp + '}';
        }
    }
}

