/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.impexp;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.utils.IoUtil;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityInfo;
import io.apicurio.registry.utils.impexp.EntityType;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import io.apicurio.registry.utils.impexp.v2.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v2.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v2.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v2.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.FileUtils;

public class EntityReader {
    private static final ObjectMapper mapper;
    private final transient Path importDirectory;
    private List<EntityInfo> entities = null;
    private int majorVersion = 3;
    private int currentIndex = 0;

    public EntityReader(Path importDirectory) {
        this.importDirectory = importDirectory;
    }

    public Entity readNextEntity() throws IOException {
        EntityType entityType;
        EntityInfo entityInfo;
        if (this.entities == null) {
            this.createEntityIndex();
        }
        if ((entityInfo = this.getNextEntityInfo()) != null && (entityType = entityInfo.getType()) != null) {
            switch (entityType) {
                case Artifact: {
                    return this.readArtifact(entityInfo);
                }
                case ArtifactRule: {
                    return this.readArtifactRule(entityInfo);
                }
                case ArtifactVersion: {
                    return this.readArtifactVersion(entityInfo);
                }
                case Content: {
                    return this.readContent(entityInfo);
                }
                case GlobalRule: {
                    return this.readGlobalRule(entityInfo);
                }
                case Group: {
                    return this.readGroup(entityInfo);
                }
                case GroupRule: {
                    return this.readGroupRule(entityInfo);
                }
                case Comment: {
                    return this.readComment(entityInfo);
                }
                case Branch: {
                    return this.readBranch(entityInfo);
                }
                case Manifest: {
                    return this.readManifest(entityInfo);
                }
            }
        }
        return null;
    }

    private EntityInfo getNextEntityInfo() {
        if (this.entities == null) {
            return null;
        }
        if (this.currentIndex >= this.entities.size()) {
            return null;
        }
        return this.entities.get(this.currentIndex++);
    }

    private void createEntityIndex() {
        EntityInfo manifest = null;
        LinkedList<EntityInfo> rules = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> content = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> groups = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> groupRules = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> artifacts = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> artifactRules = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> versions = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> branches = new LinkedList<EntityInfo>();
        LinkedList<EntityInfo> comments = new LinkedList<EntityInfo>();
        Collection allFiles = FileUtils.listFiles((File)this.importDirectory.toFile(), (String[])new String[]{"json"}, (boolean)true);
        for (File file : allFiles) {
            String path = file.getAbsolutePath();
            EntityType type = this.parseEntityType(path);
            EntityInfo entityInfo = new EntityInfo(path, type);
            switch (type) {
                case Artifact: {
                    artifacts.add(entityInfo);
                    break;
                }
                case ArtifactRule: {
                    artifactRules.add(entityInfo);
                    break;
                }
                case ArtifactVersion: {
                    versions.add(entityInfo);
                    break;
                }
                case Content: {
                    content.add(entityInfo);
                    break;
                }
                case GlobalRule: {
                    rules.add(entityInfo);
                    break;
                }
                case Group: {
                    groups.add(entityInfo);
                    break;
                }
                case GroupRule: {
                    groupRules.add(entityInfo);
                    break;
                }
                case Comment: {
                    comments.add(entityInfo);
                    break;
                }
                case Branch: {
                    branches.add(entityInfo);
                    break;
                }
                case Manifest: {
                    manifest = entityInfo;
                }
            }
        }
        this.entities = new LinkedList<EntityInfo>();
        if (manifest != null) {
            this.entities.add(manifest);
        }
        this.entities.addAll(rules);
        this.entities.addAll(content);
        this.entities.addAll(groups);
        this.entities.addAll(groupRules);
        this.entities.addAll(artifacts);
        this.entities.addAll(versions);
        this.entities.addAll(artifactRules);
        this.entities.addAll(branches);
        this.entities.addAll(comments);
    }

    private Entity readContent(EntityInfo entry) throws IOException {
        String path = entry.getPath();
        if (this.majorVersion == 3) {
            ContentEntity entity = this.readEntry(entry, ContentEntity.class);
            String dataFilePath = path.replace(".json", ".data");
            File dataFile = new File(dataFilePath);
            if (dataFile.exists() && dataFile.isFile()) {
                entity.contentBytes = IoUtil.toBytes((File)dataFile);
            }
            return entity;
        }
        io.apicurio.registry.utils.impexp.v2.ContentEntity entity = this.readEntry(entry, io.apicurio.registry.utils.impexp.v2.ContentEntity.class);
        String dataFilePath = path.replace(".json", ".data");
        File dataFile = new File(dataFilePath);
        if (dataFile.exists() && dataFile.isFile()) {
            entity.contentBytes = IoUtil.toBytes((File)dataFile);
        }
        return entity;
    }

    private ManifestEntity readManifest(EntityInfo entry) throws IOException {
        ManifestEntity manifestEntity = this.readEntry(entry, ManifestEntity.class);
        if (manifestEntity.systemVersion.startsWith("1")) {
            this.majorVersion = 1;
        }
        if (manifestEntity.systemVersion.startsWith("2")) {
            this.majorVersion = 2;
        }
        return manifestEntity;
    }

    private Entity readGroup(EntityInfo entry) throws IOException {
        return this.majorVersion == 3 ? (Entity)this.readEntry(entry, io.apicurio.registry.utils.impexp.v3.GroupEntity.class) : (Entity)this.readEntry(entry, GroupEntity.class);
    }

    private Entity readGroupRule(EntityInfo entry) throws IOException {
        return this.readEntry(entry, GroupRuleEntity.class);
    }

    private Entity readArtifact(EntityInfo entry) throws IOException {
        return this.readEntry(entry, ArtifactEntity.class);
    }

    private Entity readArtifactVersion(EntityInfo entry) throws IOException {
        return this.majorVersion == 3 ? (Entity)this.readEntry(entry, io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity.class) : (Entity)this.readEntry(entry, ArtifactVersionEntity.class);
    }

    private Entity readArtifactRule(EntityInfo entry) throws IOException {
        return this.majorVersion == 3 ? (Entity)this.readEntry(entry, io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity.class) : (Entity)this.readEntry(entry, ArtifactRuleEntity.class);
    }

    private Entity readComment(EntityInfo entry) throws IOException {
        return this.majorVersion == 3 ? (Entity)this.readEntry(entry, CommentEntity.class) : (Entity)this.readEntry(entry, io.apicurio.registry.utils.impexp.v2.CommentEntity.class);
    }

    private Entity readBranch(EntityInfo entry) throws IOException {
        return this.readEntry(entry, BranchEntity.class);
    }

    private Entity readGlobalRule(EntityInfo entry) throws IOException {
        return this.majorVersion == 3 ? (Entity)this.readEntry(entry, io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity.class) : (Entity)this.readEntry(entry, GlobalRuleEntity.class);
    }

    private EntityType parseEntityType(String path) {
        String[] split = path.split("\\.");
        if (split.length > 2) {
            String typeStr = split[split.length - 2];
            EntityType type = EntityType.valueOf(typeStr);
            return type;
        }
        return null;
    }

    private <T> T readEntry(EntityInfo entry, Class<T> theClass) throws IOException {
        File file = entry.toFile();
        byte[] bytes = IoUtil.toBytes((File)file);
        Object entity = mapper.readerFor(theClass).readValue(bytes);
        return (T)entity;
    }

    static {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        mapper = new ObjectMapper(jsonFactory);
    }
}

