/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.utils.impexp.v3;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.registry.utils.impexp.Entity;
import io.apicurio.registry.utils.impexp.EntityType;
import io.apicurio.registry.utils.impexp.ManifestEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactRuleEntity;
import io.apicurio.registry.utils.impexp.v3.ArtifactVersionEntity;
import io.apicurio.registry.utils.impexp.v3.BranchEntity;
import io.apicurio.registry.utils.impexp.v3.CommentEntity;
import io.apicurio.registry.utils.impexp.v3.ContentEntity;
import io.apicurio.registry.utils.impexp.v3.GlobalRuleEntity;
import io.apicurio.registry.utils.impexp.v3.GroupEntity;
import io.apicurio.registry.utils.impexp.v3.GroupRuleEntity;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class EntityWriter {
    private static final ObjectMapper mapper;
    private final transient ZipOutputStream zip;

    public EntityWriter(ZipOutputStream zip) {
        this.zip = zip;
    }

    public void writeEntity(Entity entity) throws IOException {
        switch (entity.getEntityType()) {
            case Content: {
                this.writeEntity((ContentEntity)entity);
                break;
            }
            case Group: {
                this.writeEntity((GroupEntity)entity);
                break;
            }
            case GroupRule: {
                this.writeEntity((GroupRuleEntity)entity);
                break;
            }
            case Artifact: {
                this.writeEntity((ArtifactEntity)entity);
                break;
            }
            case ArtifactVersion: {
                this.writeEntity((ArtifactVersionEntity)entity);
                break;
            }
            case ArtifactRule: {
                this.writeEntity((ArtifactRuleEntity)entity);
                break;
            }
            case GlobalRule: {
                this.writeEntity((GlobalRuleEntity)entity);
                break;
            }
            case Comment: {
                this.writeEntity((CommentEntity)entity);
                break;
            }
            case Branch: {
                this.writeEntity((BranchEntity)entity);
                break;
            }
            case Manifest: {
                this.writeEntity((ManifestEntity)entity);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled entity type: " + entity.getEntityType().name());
            }
        }
    }

    private void writeEntity(ContentEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Content, entity.contentHash, "json");
        ZipEntry dataEntry = this.createZipEntry(EntityType.Content, entity.contentHash, "data");
        this.write(mdEntry, entity, ContentEntity.class);
        this.zip.putNextEntry(dataEntry);
        this.zip.write(entity.contentBytes);
        this.zip.closeEntry();
    }

    private void writeEntity(ManifestEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Manifest, "manifest-" + entity.exportedOn.toInstant().toString(), "json");
        this.write(mdEntry, entity, ManifestEntity.class);
    }

    private void writeEntity(GroupEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Group, entity.groupId, "json");
        this.write(mdEntry, entity, GroupEntity.class);
    }

    private void writeEntity(GroupRuleEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.GroupRule, entity.groupId, entity.type.name(), "json");
        this.write(mdEntry, entity, GroupRuleEntity.class);
    }

    private void writeEntity(ArtifactEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Artifact, entity.groupId, entity.artifactId, "MetaData", "json");
        this.write(mdEntry, entity, ArtifactEntity.class);
    }

    private void writeEntity(ArtifactVersionEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.ArtifactVersion, entity.groupId, entity.artifactId, entity.version, "json");
        this.write(mdEntry, entity, ArtifactVersionEntity.class);
    }

    private void writeEntity(ArtifactRuleEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.ArtifactRule, entity.groupId, entity.artifactId, entity.type.name(), "json");
        this.write(mdEntry, entity, ArtifactRuleEntity.class);
    }

    private void writeEntity(GlobalRuleEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.GlobalRule, entity.ruleType.name(), "json");
        this.write(mdEntry, entity, GlobalRuleEntity.class);
    }

    private void writeEntity(CommentEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Comment, entity.globalId + 45L + entity.commentId, "json");
        this.write(mdEntry, entity, CommentEntity.class);
    }

    private void writeEntity(BranchEntity entity) throws IOException {
        ZipEntry mdEntry = this.createZipEntry(EntityType.Branch, entity.groupId, entity.artifactId, entity.branchId, "json");
        this.write(mdEntry, entity, BranchEntity.class);
    }

    private ZipEntry createZipEntry(EntityType type, String fileName, String fileExt) {
        return this.createZipEntry(type, null, null, fileName, fileExt);
    }

    private ZipEntry createZipEntry(EntityType type, String groupId, String fileName, String fileExt) {
        return this.createZipEntry(type, groupId, null, fileName, fileExt);
    }

    private ZipEntry createZipEntry(EntityType type, String groupId, String artifactId, String fileName, String fileExt) {
        String path = null;
        switch (type) {
            case ArtifactRule: {
                path = String.format("groups/%s/artifacts/%s/rules/%s.%s.%s", this.groupOrDefault(groupId), artifactId, fileName, type.name(), fileExt);
                break;
            }
            case Artifact: {
                path = String.format("groups/%s/artifacts/%s/%s.%s.%s", this.groupOrDefault(groupId), artifactId, fileName, type.name(), fileExt);
                break;
            }
            case Branch: {
                path = String.format("groups/%s/artifacts/%s/branches/%s.%s.%s", this.groupOrDefault(groupId), artifactId, fileName, type.name(), fileExt);
                break;
            }
            case ArtifactVersion: {
                path = String.format("groups/%s/artifacts/%s/versions/%s.%s.%s", this.groupOrDefault(groupId), artifactId, fileName, type.name(), fileExt);
                break;
            }
            case Content: {
                path = String.format("content/%s.%s.%s", fileName, type.name(), fileExt);
                break;
            }
            case GlobalRule: {
                path = String.format("rules/%s.%s.%s", fileName, type.name(), fileExt);
                break;
            }
            case Group: {
                path = String.format("groups/%s.%s.%s", fileName, type.name(), fileExt);
                break;
            }
            case GroupRule: {
                path = String.format("groups/%s/rules/%s.%s.%s", this.groupOrDefault(groupId), fileName, type.name(), fileExt);
                break;
            }
            case Comment: {
                path = String.format("comments/%s.%s.%s", fileName, type.name(), fileExt);
                break;
            }
            case Manifest: {
                path = String.format("%s.%s.%s", fileName, type.name(), fileExt);
                break;
            }
            default: {
                throw new RuntimeException("Unhandled entity type: " + type.name());
            }
        }
        return new ZipEntry(path);
    }

    private String groupOrDefault(String groupId) {
        return groupId == null ? "default" : groupId;
    }

    private void write(ZipEntry entry, Entity entity, Class<?> entityClass) throws IOException {
        this.zip.putNextEntry(entry);
        mapper.writerFor(entityClass).writeValue((OutputStream)this.zip, (Object)entity);
        this.zip.closeEntry();
    }

    static {
        JsonFactory jsonFactory = new JsonFactory();
        jsonFactory.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
        mapper = new ObjectMapper(jsonFactory);
    }
}

