/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal.range;

import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.semver4j.internal.range.processor.Processor;

public class RangeProcessorPipeline {
    @NotNull
    private final @NotNull ArrayList<@NotNull Processor> processors = new ArrayList();

    public RangeProcessorPipeline(@NotNull Processor currentProcessor) {
        this.processors.add(currentProcessor);
    }

    @NotNull
    public RangeProcessorPipeline addProcessor(@NotNull Processor processor) {
        this.processors.add(processor);
        return this;
    }

    @NotNull
    public String process(@NotNull String range) {
        for (Processor processor : this.processors) {
            String processedRange = processor.tryProcess(range);
            if (processedRange == null) continue;
            return processedRange;
        }
        return range;
    }

    @NotNull
    public static RangeProcessorPipeline startWith(@NotNull Processor processor) {
        return new RangeProcessorPipeline(processor);
    }
}

