/*
 * Decompiled with CFR 0.152.
 */
package org.semver4j.internal.range.processor;

import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.semver4j.Range;
import org.semver4j.internal.range.processor.Processor;
import org.semver4j.internal.range.processor.RangesUtils;

public class IvyProcessor
implements Processor {
    private static final String LATEST = "latest";
    private static final String LATEST_INTEGRATION = "latest.integration";
    @NotNull
    private static final Pattern PATTERN = Pattern.compile("^(\\[|\\]|\\()([0-9]+)?\\.?([0-9]+)?\\.?([0-9]+)?\\,([0-9]+)?\\.?([0-9]+)?\\.?([0-9]+)?(\\]|\\[|\\))$");

    @Override
    @Nullable
    public String tryProcess(@NotNull String range) {
        if (range.equals(LATEST) || range.equals(LATEST_INTEGRATION)) {
            return RangesUtils.ALL_RANGE;
        }
        Matcher matcher = PATTERN.matcher(range);
        if (!matcher.matches()) {
            return null;
        }
        String openSign = matcher.group(1);
        int fromMajor = RangesUtils.parseIntWithXSupport(matcher.group(2));
        int fromMinor = RangesUtils.parseIntWithXSupport(matcher.group(3));
        int fromPatch = RangesUtils.parseIntWithXSupport(matcher.group(4));
        int toMajor = RangesUtils.parseIntWithXSupport(matcher.group(5));
        int toMinor = RangesUtils.parseIntWithXSupport(matcher.group(6));
        int toPatch = RangesUtils.parseIntWithXSupport(matcher.group(7));
        String closeSign = matcher.group(8);
        if (RangesUtils.isX(fromMinor)) {
            fromMinor = 0;
        }
        if (RangesUtils.isX(fromPatch)) {
            fromPatch = 0;
        }
        if (RangesUtils.isX(toMinor)) {
            toMinor = 0;
        }
        if (RangesUtils.isX(toPatch)) {
            toPatch = 0;
        }
        boolean openInclusive = this.isInclusiveRange(openSign);
        boolean closeInclusive = this.isInclusiveRange(closeSign);
        if (openInclusive && closeInclusive) {
            if (openSign.equals("[") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("[") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("]") && closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (openSign.equals("]") && closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d %s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch, Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
        } else if (closeSign.equals(")")) {
            if (openSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GTE.asString(), fromMajor, fromMinor, fromPatch);
            }
            if (openSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.GT.asString(), fromMajor, fromMinor, fromPatch);
            }
        } else if (openSign.equals("(")) {
            if (closeSign.equals("]")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.LTE.asString(), toMajor, toMinor, toPatch);
            }
            if (closeSign.equals("[")) {
                return String.format(Locale.ROOT, "%s%d.%d.%d", Range.RangeOperator.LT.asString(), toMajor, toMinor, toPatch);
            }
        }
        return range;
    }

    private boolean isInclusiveRange(@NotNull String character) {
        return character.equals("[") || character.equals("]");
    }
}

