/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.microsoft.kiota.RequestAdapter;
import io.apicurio.registry.client.auth.VertXAuthFactory;
import io.apicurio.registry.rest.client.RegistryClient;
import io.kiota.http.vertx.VertXRequestAdapter;
import io.vertx.core.Vertx;
import io.vertx.ext.web.client.WebClient;
import java.util.Locale;
import java.util.concurrent.ExecutionException;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;

public abstract class AbstractRegistryMojo
extends AbstractMojo {
    @Parameter(required=true, property="apicurio.url")
    String registryUrl;
    @Parameter(property="auth.server.url")
    String authServerUrl;
    @Parameter(property="client.id")
    String clientId;
    @Parameter(property="client.secret")
    String clientSecret;
    @Parameter(property="client.scope")
    String clientScope;
    @Parameter(property="username")
    String username;
    @Parameter(property="password")
    String password;
    private RegistryClient client;

    protected RegistryClient getClient() {
        if (this.client == null) {
            WebClient provider = null;
            provider = this.authServerUrl != null && this.clientId != null && this.clientSecret != null ? VertXAuthFactory.buildOIDCWebClient((String)this.authServerUrl, (String)this.clientId, (String)this.clientSecret, (String)this.clientScope) : (this.username != null && this.password != null ? VertXAuthFactory.buildSimpleAuthWebClient((String)this.username, (String)this.password) : WebClient.create((Vertx)VertXAuthFactory.defaultVertx));
            VertXRequestAdapter adapter = new VertXRequestAdapter(provider);
            adapter.setBaseUrl(this.registryUrl);
            this.client = new RegistryClient((RequestAdapter)adapter);
        }
        return this.client;
    }

    public void setClient(RegistryClient client) {
        this.client = client;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            this.executeInternal();
        }
        catch (ExecutionException e) {
            throw new MojoExecutionException((Throwable)e);
        }
        catch (InterruptedException e) {
            throw new MojoFailureException((Throwable)e);
        }
        this.closeClients();
    }

    private void closeClients() {
    }

    protected abstract void executeInternal() throws MojoExecutionException, MojoFailureException, ExecutionException, InterruptedException;

    protected String getContentTypeByExtension(String fileName) {
        if (fileName == null) {
            return null;
        }
        String[] temp = fileName.split("[.]");
        String extension = temp[temp.length - 1];
        switch (extension.toLowerCase(Locale.ROOT)) {
            case "avro": 
            case "avsc": 
            case "json": {
                return "application/json";
            }
            case "yml": 
            case "yaml": {
                return "application/x-yaml";
            }
            case "graphql": {
                return "application/graphql";
            }
            case "proto": {
                return "application/x-protobuf";
            }
            case "wsdl": 
            case "xsd": 
            case "xml": {
                return "application/xml";
            }
        }
        return null;
    }

    public void setRegistryUrl(String registryUrl) {
        this.registryUrl = registryUrl;
    }

    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public void setClientScope(String clientScope) {
        this.clientScope = clientScope;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }
}

