/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.squareup.wire.schema.internal.parser.ProtoFileElement;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.maven.AbstractDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import io.apicurio.registry.utils.protobuf.schema.FileDescriptorUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtobufDirectoryParser
extends AbstractDirectoryParser<Descriptors.FileDescriptor> {
    private static final String PROTO_SCHEMA_EXTENSION = ".proto";
    private static final Logger log = LoggerFactory.getLogger(ProtobufDirectoryParser.class);

    public ProtobufDirectoryParser(RegistryClient client) {
        super(client);
    }

    @Override
    public ParsedDirectoryWrapper<Descriptors.FileDescriptor> parse(File protoFile) {
        Set protoFiles = Arrays.stream(Objects.requireNonNull(protoFile.getParentFile().listFiles((dir, name) -> name.endsWith(PROTO_SCHEMA_EXTENSION)))).filter(file -> !file.getName().equals(protoFile.getName())).collect(Collectors.toSet());
        try {
            HashMap<String, String> requiredSchemaDefs = new HashMap<String, String>();
            Descriptors.FileDescriptor schemaDescriptor = FileDescriptorUtils.parseProtoFileWithDependencies((File)protoFile, protoFiles, requiredSchemaDefs);
            assert (ProtobufDirectoryParser.allDependenciesHaveSamePackageName(requiredSchemaDefs, schemaDescriptor.getPackage())) : "All dependencies must have the same package name as the main proto file";
            Map<String, TypedContent> schemaContents = this.convertSchemaDefs(requiredSchemaDefs, schemaDescriptor.getPackage());
            return new DescriptorWrapper(schemaDescriptor, schemaContents);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new RuntimeException("Failed to read schema file: " + protoFile, e);
        }
        catch (FileDescriptorUtils.ReadSchemaException e) {
            log.warn("Error processing Avro schema with name {}. This usually means that the references are not ready yet to read it", (Object)e.file());
            throw new RuntimeException(e.getCause());
        }
        catch (FileDescriptorUtils.ParseSchemaException e) {
            log.warn("Error processing Avro schema with name {}. This usually means that the references are not ready yet to parse it", (Object)e.fileName());
            throw new RuntimeException(e.getCause());
        }
    }

    private static boolean allDependenciesHaveSamePackageName(Map<String, String> schemas, String mainProtoPackageName) {
        return schemas.keySet().stream().allMatch(fullDepName -> fullDepName.contains(mainProtoPackageName));
    }

    private Map<String, TypedContent> convertSchemaDefs(Map<String, String> requiredSchemaDefs, String mainProtoPackageName) {
        if (requiredSchemaDefs.isEmpty()) {
            return Map.of();
        }
        HashMap<String, TypedContent> schemaDefs = new HashMap<String, TypedContent>(requiredSchemaDefs.size());
        for (Map.Entry<String, String> entry : requiredSchemaDefs.entrySet()) {
            TypedContent content;
            String fileName = FileDescriptorUtils.extractProtoFileName((String)entry.getKey());
            if (schemaDefs.put(fileName, content = TypedContent.create((ContentHandle)ContentHandle.create((String)entry.getValue()), (String)"application/x-protobuf")) == null) continue;
            log.warn("There's a clash of dependency name, likely due to stripping the expected package name ie {}: dependencies: {}", (Object)mainProtoPackageName, (Object)Arrays.toString(requiredSchemaDefs.keySet().toArray(new Object[0])));
        }
        return schemaDefs;
    }

    @Override
    public List<ArtifactReference> handleSchemaReferences(RegisterArtifact rootArtifact, Descriptors.FileDescriptor protoSchema, Map<String, TypedContent> fileContents) throws FileNotFoundException, InterruptedException, ExecutionException {
        HashSet<ArtifactReference> references = new HashSet<ArtifactReference>();
        HashSet<Descriptors.FileDescriptor> baseDeps = new HashSet<Descriptors.FileDescriptor>(Arrays.asList(FileDescriptorUtils.baseDependencies()));
        ProtoFileElement rootSchemaElement = FileDescriptorUtils.fileDescriptorToProtoFile((DescriptorProtos.FileDescriptorProto)protoSchema.toProto());
        for (Descriptors.FileDescriptor dependency : protoSchema.getDependencies()) {
            List<ArtifactReference> nestedArtifactReferences = new ArrayList<ArtifactReference>();
            String dependencyFullName = dependency.getPackage() + "/" + dependency.getName();
            if (baseDeps.contains(dependency) || !rootSchemaElement.getImports().contains(dependencyFullName)) continue;
            RegisterArtifact nestedArtifact = this.buildFromRoot(rootArtifact, dependencyFullName);
            if (!dependency.getDependencies().isEmpty()) {
                nestedArtifactReferences = this.handleSchemaReferences(nestedArtifact, dependency, fileContents);
            }
            references.add(this.registerNestedSchema(dependencyFullName, nestedArtifactReferences, nestedArtifact, fileContents.get(dependency.getName()).getContent().content()));
        }
        return new ArrayList<ArtifactReference>(references);
    }

    public static class DescriptorWrapper
    implements ParsedDirectoryWrapper<Descriptors.FileDescriptor> {
        final Descriptors.FileDescriptor fileDescriptor;
        final Map<String, TypedContent> schemaContents;

        public DescriptorWrapper(Descriptors.FileDescriptor fileDescriptor, Map<String, TypedContent> schemaContents) {
            this.fileDescriptor = fileDescriptor;
            this.schemaContents = schemaContents;
        }

        @Override
        public Descriptors.FileDescriptor getSchema() {
            return this.fileDescriptor;
        }

        @Override
        public Map<String, TypedContent> getSchemaContents() {
            return this.schemaContents;
        }
    }
}

