/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.Descriptors;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.content.TypedContent;
import io.apicurio.registry.content.refs.ReferenceFinder;
import io.apicurio.registry.maven.AbstractRegistryMojo;
import io.apicurio.registry.maven.AvroDirectoryParser;
import io.apicurio.registry.maven.ExistingReference;
import io.apicurio.registry.maven.JsonSchemaDirectoryParser;
import io.apicurio.registry.maven.ParsedDirectoryWrapper;
import io.apicurio.registry.maven.ProtobufDirectoryParser;
import io.apicurio.registry.maven.RegisterArtifact;
import io.apicurio.registry.maven.RegisterArtifactReference;
import io.apicurio.registry.maven.refs.IndexedResource;
import io.apicurio.registry.maven.refs.ReferenceIndex;
import io.apicurio.registry.rest.client.models.ArtifactReference;
import io.apicurio.registry.rest.client.models.CreateArtifact;
import io.apicurio.registry.rest.client.models.CreateArtifactResponse;
import io.apicurio.registry.rest.client.models.CreateVersion;
import io.apicurio.registry.rest.client.models.IfArtifactExists;
import io.apicurio.registry.rest.client.models.ProblemDetails;
import io.apicurio.registry.rest.client.models.VersionContent;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.types.provider.ArtifactTypeUtilProvider;
import io.apicurio.registry.types.provider.DefaultArtifactTypeUtilProviderImpl;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.everit.json.schema.Schema;

@Mojo(name="register")
public class RegisterRegistryMojo
extends AbstractRegistryMojo {
    @Parameter(required=true)
    List<ExistingReference> existingReferences;
    @Parameter(required=true)
    List<RegisterArtifact> artifacts;
    @Parameter(property="skipRegister", defaultValue="false")
    boolean skip;
    DefaultArtifactTypeUtilProviderImpl utilProviderFactory = new DefaultArtifactTypeUtilProviderImpl();

    protected boolean validate() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"register is skipped.");
            return false;
        }
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No artifacts are configured for registration.");
            return false;
        }
        int idx = 0;
        int errorCount = 0;
        for (RegisterArtifact artifact : this.artifacts) {
            if (artifact.getGroupId() == null) {
                this.getLog().error((CharSequence)String.format("GroupId is required when registering an artifact.  Missing from artifacts[%d].", idx));
                ++errorCount;
            }
            if (artifact.getArtifactId() == null) {
                this.getLog().error((CharSequence)String.format("ArtifactId is required when registering an artifact.  Missing from artifacts[%s].", idx));
                ++errorCount;
            }
            if (artifact.getFile() == null) {
                this.getLog().error((CharSequence)String.format("File is required when registering an artifact.  Missing from artifacts[%s].", idx));
                ++errorCount;
            } else if (!artifact.getFile().exists()) {
                this.getLog().error((CharSequence)String.format("Artifact file to register is configured but file does not exist: %s", artifact.getFile().getPath()));
                ++errorCount;
            }
            ++idx;
        }
        if (errorCount > 0) {
            throw new MojoExecutionException("Invalid configuration of the Register Artifact(s) mojo. See the output log for details.");
        }
        return true;
    }

    @Override
    protected void executeInternal() throws MojoExecutionException {
        int errorCount = 0;
        if (this.validate()) {
            for (RegisterArtifact artifact : this.artifacts) {
                String groupId = artifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                try {
                    if (artifact.getAutoRefs() != null && artifact.getAutoRefs().booleanValue()) {
                        ReferenceIndex index = RegisterRegistryMojo.createIndex(artifact.getFile());
                        this.addExistingReferencesToIndex(index, this.existingReferences);
                        this.addExistingReferencesToIndex(index, artifact.getExistingReferences());
                        Stack<RegisterArtifact> registrationStack = new Stack<RegisterArtifact>();
                        this.registerWithAutoRefs(artifact, index, registrationStack);
                        continue;
                    }
                    if (artifact.getAnalyzeDirectory() != null && artifact.getAnalyzeDirectory().booleanValue()) {
                        this.registerDirectory(artifact);
                        continue;
                    }
                    List<ArtifactReference> references = new ArrayList<ArtifactReference>();
                    if (RegisterRegistryMojo.hasReferences(artifact)) {
                        references = this.registerArtifactReferences(artifact.getReferences());
                    }
                    this.registerArtifact(artifact, references);
                }
                catch (Exception e) {
                    ++errorCount;
                    this.getLog().error((CharSequence)String.format("Exception while registering artifact [%s] / [%s]", groupId, artifactId), (Throwable)e);
                }
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Errors while registering artifacts ...");
            }
        }
    }

    private CreateArtifactResponse registerWithAutoRefs(RegisterArtifact artifact, ReferenceIndex index, Stack<RegisterArtifact> registrationStack) throws IOException, ExecutionException, InterruptedException {
        if (RegisterRegistryMojo.loopDetected(artifact, registrationStack)) {
            throw new RuntimeException("Artifact reference loop detected (not supported): " + RegisterRegistryMojo.printLoop(registrationStack));
        }
        registrationStack.push(artifact);
        ContentHandle artifactContent = RegisterRegistryMojo.readContent(artifact.getFile());
        String artifactContentType = this.getContentTypeByExtension(artifact.getFile().getName());
        TypedContent typedArtifactContent = TypedContent.create((ContentHandle)artifactContent, (String)artifactContentType);
        ArtifactTypeUtilProvider provider = this.utilProviderFactory.getArtifactTypeProvider(artifact.getArtifactType());
        ReferenceFinder referenceFinder = provider.getReferenceFinder();
        Set externalReferences = referenceFinder.findExternalReferences(typedArtifactContent);
        List<ArtifactReference> registeredReferences = externalReferences.stream().map(externalRef -> {
            IndexedResource iresource = index.lookup(externalRef.getResource(), Paths.get(artifact.getFile().toURI()));
            if (iresource == null) {
                throw new RuntimeException("Reference could not be resolved.  From: " + artifact.getFile().getName() + "  To: " + externalRef.getFullReference());
            }
            if (!iresource.isRegistered()) {
                String artifactId = externalRef.getResource();
                File localFile = RegisterRegistryMojo.getLocalFile(iresource.getPath());
                RegisterArtifact refArtifact = RegisterRegistryMojo.buildFromRoot(artifact, artifactId);
                refArtifact.setArtifactType(iresource.getType());
                refArtifact.setVersion(null);
                refArtifact.setFile(localFile);
                refArtifact.setContentType(this.getContentTypeByExtension(localFile.getName()));
                try {
                    CreateArtifactResponse car = this.registerWithAutoRefs(refArtifact, index, registrationStack);
                    VersionMetaData amd = car.getVersion();
                    iresource.setRegistration(amd);
                }
                catch (IOException | InterruptedException | ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }
            ArtifactReference reference = new ArtifactReference();
            reference.setName(externalRef.getFullReference());
            reference.setVersion(iresource.getRegistration().getVersion());
            reference.setGroupId(iresource.getRegistration().getGroupId());
            reference.setArtifactId(iresource.getRegistration().getArtifactId());
            return reference;
        }).sorted((ref1, ref2) -> ref1.getName().compareTo(ref2.getName())).collect(Collectors.toList());
        registrationStack.pop();
        return this.registerArtifact(artifact, registeredReferences);
    }

    private void registerDirectory(RegisterArtifact artifact) throws IOException, ExecutionException, InterruptedException {
        switch (artifact.getArtifactType()) {
            case "AVRO": {
                AvroDirectoryParser avroDirectoryParser = new AvroDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<org.apache.avro.Schema> schema = avroDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, avroDirectoryParser.handleSchemaReferences(artifact, schema.getSchema(), schema.getSchemaContents()));
                break;
            }
            case "PROTOBUF": {
                ProtobufDirectoryParser protobufDirectoryParser = new ProtobufDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<Descriptors.FileDescriptor> protoSchema = protobufDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, protobufDirectoryParser.handleSchemaReferences(artifact, protoSchema.getSchema(), protoSchema.getSchemaContents()));
                break;
            }
            case "JSON": {
                JsonSchemaDirectoryParser jsonSchemaDirectoryParser = new JsonSchemaDirectoryParser(this.getClient());
                ParsedDirectoryWrapper<Schema> jsonSchema = jsonSchemaDirectoryParser.parse(artifact.getFile());
                this.registerArtifact(artifact, jsonSchemaDirectoryParser.handleSchemaReferences(artifact, jsonSchema.getSchema(), jsonSchema.getSchemaContents()));
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Artifact type not recognized for analyzing a directory structure %s", artifact.getArtifactType()));
            }
        }
    }

    private CreateArtifactResponse registerArtifact(RegisterArtifact artifact, List<ArtifactReference> references) throws FileNotFoundException, ExecutionException, InterruptedException {
        return this.registerArtifact(artifact, new FileInputStream(artifact.getFile()), references);
    }

    private CreateArtifactResponse registerArtifact(RegisterArtifact artifact, InputStream artifactContent, List<ArtifactReference> references) throws ExecutionException, InterruptedException {
        String groupId = artifact.getGroupId();
        String artifactId = artifact.getArtifactId();
        String version = artifact.getVersion();
        String type = artifact.getArtifactType();
        Boolean canonicalize = artifact.getCanonicalize();
        String ct = artifact.getContentType() == null ? "application/json" : artifact.getContentType();
        String data = null;
        try {
            if (artifact.getMinify() != null && artifact.getMinify().booleanValue()) {
                ObjectMapper objectMapper = new ObjectMapper();
                JsonNode jsonNode = (JsonNode)objectMapper.readValue(artifactContent, JsonNode.class);
                data = jsonNode.toString();
            } else {
                data = new String(artifactContent.readAllBytes(), StandardCharsets.UTF_8);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        CreateArtifact createArtifact = new CreateArtifact();
        createArtifact.setArtifactId(artifactId);
        createArtifact.setArtifactType(type);
        CreateVersion createVersion = new CreateVersion();
        createVersion.setVersion(version);
        createArtifact.setFirstVersion(createVersion);
        VersionContent content = new VersionContent();
        content.setContent(data);
        content.setContentType(ct);
        content.setReferences(references.stream().map(r -> {
            ArtifactReference ref = new ArtifactReference();
            ref.setArtifactId(r.getArtifactId());
            ref.setGroupId(r.getGroupId());
            ref.setVersion(r.getVersion());
            ref.setName(r.getName());
            return ref;
        }).collect(Collectors.toList()));
        createVersion.setContent(content);
        try {
            CreateArtifactResponse vmd = this.getClient().groups().byGroupId(groupId).artifacts().post(createArtifact, config -> {
                if (artifact.getIfExists() != null) {
                    config.queryParameters.ifExists = IfArtifactExists.forValue((String)artifact.getIfExists().value());
                }
                config.queryParameters.canonical = canonicalize;
            });
            this.getLog().info((CharSequence)String.format("Successfully registered artifact [%s] / [%s].  GlobalId is [%d]", groupId, artifactId, vmd.getVersion().getGlobalId()));
            return vmd;
        }
        catch (ProblemDetails e) {
            throw new RuntimeException(e.getDetail());
        }
    }

    private static boolean hasReferences(RegisterArtifact artifact) {
        return artifact.getReferences() != null && !artifact.getReferences().isEmpty();
    }

    private List<ArtifactReference> registerArtifactReferences(List<RegisterArtifactReference> referencedArtifacts) throws FileNotFoundException, ExecutionException, InterruptedException {
        ArrayList<ArtifactReference> references = new ArrayList<ArtifactReference>();
        for (RegisterArtifactReference artifact : referencedArtifacts) {
            List<ArtifactReference> nestedReferences = new ArrayList<ArtifactReference>();
            if (RegisterRegistryMojo.hasReferences(artifact)) {
                nestedReferences = this.registerArtifactReferences(artifact.getReferences());
            }
            CreateArtifactResponse car = this.registerArtifact(artifact, nestedReferences);
            VersionMetaData metaData = car.getVersion();
            references.add(RegisterRegistryMojo.buildReferenceFromMetadata(metaData, artifact.getName()));
        }
        return references;
    }

    public void setArtifacts(List<RegisterArtifact> artifacts) {
        this.artifacts = artifacts;
    }

    public void setSkip(boolean skip) {
        this.skip = skip;
    }

    private static ArtifactReference buildReferenceFromMetadata(VersionMetaData metaData, String referenceName) {
        ArtifactReference reference = new ArtifactReference();
        reference.setName(referenceName);
        reference.setArtifactId(metaData.getArtifactId());
        reference.setGroupId(metaData.getGroupId());
        reference.setVersion(metaData.getVersion());
        return reference;
    }

    private static ReferenceIndex createIndex(File file) {
        ReferenceIndex index = new ReferenceIndex(file.getParentFile().toPath());
        Collection allFiles = FileUtils.listFiles((File)file.getParentFile(), null, (boolean)true);
        allFiles.stream().filter(f -> f.isFile()).forEach(f -> index.index(f.toPath(), RegisterRegistryMojo.readContent(f)));
        return index;
    }

    private void addExistingReferencesToIndex(ReferenceIndex index, List<ExistingReference> existingReferences) throws ExecutionException, InterruptedException {
        if (existingReferences != null && !existingReferences.isEmpty()) {
            for (ExistingReference ref : existingReferences) {
                VersionMetaData vmd;
                if (ref.getVersion() == null || "LATEST".equalsIgnoreCase(ref.getVersion())) {
                    vmd = this.getClient().groups().byGroupId(ref.getGroupId()).artifacts().byArtifactId(ref.getArtifactId()).versions().byVersionExpression("branch=latest").get();
                } else {
                    vmd = new VersionMetaData();
                    vmd.setGroupId(ref.getGroupId());
                    vmd.setArtifactId(ref.getArtifactId());
                    vmd.setVersion(ref.getVersion());
                }
                index.index(ref.getResourceName(), vmd);
            }
        }
    }

    protected static ContentHandle readContent(File file) {
        try {
            return ContentHandle.create((byte[])Files.readAllBytes(file.toPath()));
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read schema file: " + file, e);
        }
    }

    protected static RegisterArtifact buildFromRoot(RegisterArtifact rootArtifact, String artifactId) {
        RegisterArtifact nestedSchema = new RegisterArtifact();
        nestedSchema.setCanonicalize(rootArtifact.getCanonicalize());
        nestedSchema.setArtifactId(artifactId);
        nestedSchema.setGroupId(rootArtifact.getGroupId());
        nestedSchema.setContentType(rootArtifact.getContentType());
        nestedSchema.setArtifactType(rootArtifact.getArtifactType());
        nestedSchema.setMinify(rootArtifact.getMinify());
        nestedSchema.setContentType(rootArtifact.getContentType());
        nestedSchema.setIfExists(rootArtifact.getIfExists());
        nestedSchema.setAutoRefs(rootArtifact.getAutoRefs());
        return nestedSchema;
    }

    private static File getLocalFile(Path path) {
        return path.toFile();
    }

    private static boolean loopDetected(RegisterArtifact artifact, Stack<RegisterArtifact> registrationStack) {
        for (RegisterArtifact stackArtifact : registrationStack) {
            if (!artifact.getFile().equals(stackArtifact.getFile())) continue;
            return true;
        }
        return false;
    }

    private static String printLoop(Stack<RegisterArtifact> registrationStack) {
        return registrationStack.stream().map(artifact -> artifact.getFile().getName()).collect(Collectors.joining(" -> "));
    }
}

