/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven;

import io.apicurio.registry.maven.AbstractRegistryMojo;
import io.apicurio.registry.maven.TestArtifact;
import io.apicurio.registry.rest.client.models.CreateVersion;
import io.apicurio.registry.rest.client.models.VersionContent;
import io.apicurio.registry.utils.IoUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="test-update")
public class TestUpdateRegistryMojo
extends AbstractRegistryMojo {
    @Parameter(required=true)
    List<TestArtifact> artifacts;

    protected void validate() throws MojoExecutionException {
        if (this.artifacts == null || this.artifacts.isEmpty()) {
            this.getLog().warn((CharSequence)"No artifacts are configured for testing/validation.");
        } else {
            int idx = 0;
            int errorCount = 0;
            for (TestArtifact artifact : this.artifacts) {
                if (artifact.getGroupId() == null) {
                    this.getLog().error((CharSequence)String.format("GroupId is required when testing an artifact.  Missing from artifacts[%d].", idx));
                    ++errorCount;
                }
                if (artifact.getArtifactId() == null) {
                    this.getLog().error((CharSequence)String.format("ArtifactId is required when testing an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                }
                if (artifact.getFile() == null) {
                    this.getLog().error((CharSequence)String.format("File is required when testing an artifact.  Missing from artifacts[%s].", idx));
                    ++errorCount;
                } else if (!artifact.getFile().isFile()) {
                    this.getLog().error((CharSequence)String.format("Artifact file to test is configured but file does not exist or is not a file: %s", artifact.getFile().getPath()));
                    ++errorCount;
                }
                ++idx;
            }
            if (errorCount > 0) {
                throw new MojoExecutionException("Invalid configuration of the Test Update Artifact(s) mojo. See the output log for details.");
            }
        }
    }

    @Override
    protected void executeInternal() throws MojoExecutionException {
        this.validate();
        int errorCount = 0;
        if (this.artifacts != null) {
            for (TestArtifact artifact : this.artifacts) {
                String groupId = artifact.getGroupId();
                String artifactId = artifact.getArtifactId();
                String contentType = this.contentType(artifact);
                try (FileInputStream data = new FileInputStream(artifact.getFile());){
                    String content = IoUtil.toString((InputStream)data);
                    CreateVersion cv = new CreateVersion();
                    cv.setContent(new VersionContent());
                    cv.getContent().setContentType(contentType);
                    cv.getContent().setContent(content);
                    this.getClient().groups().byGroupId(groupId).artifacts().byArtifactId(artifactId).versions().post(cv, config -> {
                        config.queryParameters.dryRun = true;
                    });
                    this.getLog().info((CharSequence)String.format("[%s] / [%s] :: Artifact successfully tested (updating is allowed for the given content).", groupId, artifactId));
                }
                catch (Exception e) {
                    ++errorCount;
                    this.getLog().error((CharSequence)String.format("[%s] / [%s] :: Artifact test FAILED (updating is not allowed for the given content).", groupId, artifactId), (Throwable)e);
                }
            }
        }
        if (errorCount > 0) {
            throw new MojoExecutionException("Errors while testing artifacts for update...");
        }
    }

    private String contentType(TestArtifact testArtifact) {
        String contentType = testArtifact.getContentType();
        if (contentType != null) {
            return contentType;
        }
        return this.getContentTypeByExtension(testArtifact.getFile().getName());
    }

    public void setArtifacts(List<TestArtifact> artifacts) {
        this.artifacts = artifacts;
    }
}

