/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.maven.refs;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apicurio.datamodels.Library;
import io.apicurio.datamodels.models.Document;
import io.apicurio.datamodels.models.Node;
import io.apicurio.datamodels.util.ModelTypeUtil;
import io.apicurio.registry.content.ContentHandle;
import io.apicurio.registry.maven.refs.IndexedResource;
import io.apicurio.registry.rest.client.models.VersionMetaData;
import io.apicurio.registry.utils.protobuf.schema.ProtobufFile;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;

public class ReferenceIndex {
    private static final ObjectMapper mapper = new ObjectMapper();
    private Set<IndexedResource> index = new HashSet<IndexedResource>();
    private Set<Path> schemaPaths = new HashSet<Path>();

    public ReferenceIndex() {
    }

    public ReferenceIndex(Path schemaPath) {
        this.schemaPaths.add(schemaPath);
    }

    public void addSchemaPath(Path path) {
        this.schemaPaths.add(path);
    }

    public IndexedResource lookup(String resourceName, Path relativeToFile) {
        return this.index.stream().filter(resource -> resource.matches(resourceName, relativeToFile, this.schemaPaths)).findFirst().orElse(null);
    }

    public void index(String resourceName, VersionMetaData vmd) {
        IndexedResource res = new IndexedResource(null, null, resourceName, null);
        res.setRegistration(vmd);
        this.index.add(res);
    }

    public void index(Path path, ContentHandle content) {
        try {
            JsonNode tree = mapper.readTree(content.content());
            if (tree.has("openapi") || tree.has("swagger") || tree.has("asyncapi")) {
                this.indexDataModels(path, content);
            }
            if (tree.has("$schema") && !tree.get("$schema").isNull()) {
                this.indexJsonSchema(tree, path, content);
            }
            this.indexAvro(path, content, tree);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.indexProto(path, content);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    private void indexAvro(Path path, ContentHandle content, JsonNode parsed) {
        String ns = parsed.get("namespace").asText();
        String name = parsed.get("name").asText();
        String resourceName = ns != null ? ns + "." + name : name;
        IndexedResource resource = new IndexedResource(path, "AVRO", resourceName, content);
        this.index.add(resource);
    }

    private void indexProto(Path path, ContentHandle content) {
        ProtobufFile.toProtoFileElement((String)content.content());
        IndexedResource resource = new IndexedResource(path, "PROTOBUF", null, content);
        this.index.add(resource);
    }

    private void indexJsonSchema(JsonNode schema, Path path, ContentHandle content) {
        String resourceName = null;
        if (schema.has("$id")) {
            resourceName = schema.get("$id").asText(null);
        }
        IndexedResource resource = new IndexedResource(path, "JSON", resourceName, content);
        this.index.add(resource);
    }

    private void indexDataModels(Path path, ContentHandle content) {
        Document doc = Library.readDocumentFromJSONString((String)content.content());
        if (doc == null) {
            throw new UnsupportedOperationException("Content is not OpenAPI or AsyncAPI.");
        }
        String type = "OPENAPI";
        if (ModelTypeUtil.isAsyncApiModel((Node)doc)) {
            type = "ASYNCAPI";
        }
        IndexedResource resource = new IndexedResource(path, type, null, content);
        this.index.add(resource);
    }
}

