/*
 * Decompiled with CFR 0.152.
 */
package io.apicurio.registry.serde;

import io.apicurio.registry.resolver.ParsedSchema;
import io.apicurio.registry.resolver.SchemaLookupResult;
import io.apicurio.registry.resolver.SchemaParser;
import io.apicurio.registry.resolver.SchemaResolver;
import io.apicurio.registry.resolver.strategy.ArtifactReference;
import io.apicurio.registry.resolver.strategy.ArtifactReferenceResolverStrategy;
import io.apicurio.registry.resolver.utils.Utils;
import io.apicurio.registry.rest.client.RegistryClient;
import io.apicurio.registry.serde.BaseSerde;
import io.apicurio.registry.serde.config.SerdeConfig;
import io.apicurio.registry.serde.config.SerdeDeserializerConfig;
import io.apicurio.registry.serde.fallback.DefaultFallbackArtifactProvider;
import io.apicurio.registry.serde.fallback.FallbackArtifactProvider;
import java.nio.ByteBuffer;

public abstract class AbstractDeserializer<T, U>
implements AutoCloseable {
    private FallbackArtifactProvider fallbackArtifactProvider;
    private final BaseSerde<T, U> baseSerde;

    public AbstractDeserializer() {
        this.baseSerde = new BaseSerde();
    }

    public AbstractDeserializer(RegistryClient client) {
        this.baseSerde = new BaseSerde(client);
    }

    public AbstractDeserializer(SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(schemaResolver);
    }

    public AbstractDeserializer(RegistryClient client, SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(client, schemaResolver);
    }

    public AbstractDeserializer(RegistryClient client, ArtifactReferenceResolverStrategy<T, U> strategy, SchemaResolver<T, U> schemaResolver) {
        this.baseSerde = new BaseSerde<T, U>(client, strategy, schemaResolver);
    }

    public BaseSerde<T, U> getSerdeConfigurer() {
        return this.baseSerde;
    }

    public void configure(SerdeConfig config, boolean isKey) {
        this.baseSerde.configure(config, isKey, this.schemaParser());
        this.configureDeserialization(config, isKey);
    }

    private void configureDeserialization(SerdeConfig config, boolean isKey) {
        SerdeDeserializerConfig deserializerConfig = new SerdeDeserializerConfig(config.originals());
        Object fallbackProvider = deserializerConfig.getFallbackArtifactProvider();
        Utils.instantiate(FallbackArtifactProvider.class, (Object)fallbackProvider, this::setFallbackArtifactProvider);
        this.fallbackArtifactProvider.configure(config.originals(), isKey);
        if (this.fallbackArtifactProvider instanceof DefaultFallbackArtifactProvider && !((DefaultFallbackArtifactProvider)this.fallbackArtifactProvider).isConfigured()) {
            this.fallbackArtifactProvider = null;
        }
    }

    public abstract SchemaParser<T, U> schemaParser();

    public U deserializeData(String topic, byte[] data) {
        if (data == null) {
            return null;
        }
        ByteBuffer buffer = BaseSerde.getByteBuffer(data);
        ArtifactReference artifactReference = this.baseSerde.getIdHandler().readId(buffer);
        SchemaLookupResult<T> schema = this.resolve(topic, data, artifactReference);
        int length = buffer.limit() - 1 - this.baseSerde.getIdHandler().idSize();
        int start = buffer.position() + buffer.arrayOffset();
        return this.readData(schema.getParsedSchema(), buffer, start, length);
    }

    protected abstract U readData(ParsedSchema<T> var1, ByteBuffer var2, int var3, int var4);

    protected U readData(String topic, byte[] data, ArtifactReference artifactReference) {
        SchemaLookupResult<T> schema = this.resolve(topic, data, artifactReference);
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int length = buffer.limit();
        int start = buffer.position();
        return this.readData(schema.getParsedSchema(), buffer, start, length);
    }

    protected SchemaLookupResult<T> resolve(String topic, byte[] data, ArtifactReference artifactReference) {
        try {
            return this.baseSerde.getSchemaResolver().resolveSchemaByArtifactReference(artifactReference);
        }
        catch (RuntimeException e) {
            if (this.getFallbackArtifactProvider() == null) {
                throw e;
            }
            try {
                ArtifactReference fallbackReference = this.getFallbackArtifactProvider().get(topic, data);
                return this.baseSerde.getSchemaResolver().resolveSchemaByArtifactReference(fallbackReference);
            }
            catch (RuntimeException fe) {
                fe.addSuppressed(e);
                throw fe;
            }
        }
    }

    public FallbackArtifactProvider getFallbackArtifactProvider() {
        return this.fallbackArtifactProvider;
    }

    public void setFallbackArtifactProvider(FallbackArtifactProvider fallbackArtifactProvider) {
        this.fallbackArtifactProvider = fallbackArtifactProvider;
    }

    @Override
    public void close() {
        this.baseSerde.close();
    }
}

