/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.logging.log4j2;

import io.apiman.common.logging.IApimanLogger;
import io.apiman.common.logging.IDelegateFactory;
import io.apiman.common.logging.LogLevel;
import io.apiman.common.logging.annotations.ApimanLoggerFactory;
import io.apiman.common.logging.log4j2.Log4j2LoggerImpl;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.logging.log4j.message.FormattedMessageFactory;
import org.apache.logging.log4j.message.MessageFactory;

@ApimanLoggerFactory(value="log4j2")
public class Log4j2LoggerFactory
implements IDelegateFactory {
    private final FormattedMessageFactory formattedMessageFactory = new FormattedMessageFactory();
    private final LoggerContext context = (LoggerContext)LogManager.getContext((boolean)false);

    public IApimanLogger createLogger(String name) {
        return new Log4j2LoggerImpl((Logger)this.context.getLogger(name, (MessageFactory)this.formattedMessageFactory));
    }

    public IApimanLogger createLogger(Class<?> klazz) {
        return new Log4j2LoggerImpl((Logger)this.context.getLogger(klazz, (MessageFactory)this.formattedMessageFactory));
    }

    public IDelegateFactory overrideLoggerConfig(File newLoggerConfig) {
        this.context.setConfigLocation(newLoggerConfig.toURI());
        return this;
    }

    public IDelegateFactory overrideLoggerConfig(Map<String, LogLevel> newLoggerConfig) {
        HashMap<String, Level> log4j2LevelMap = new HashMap<String, Level>(newLoggerConfig.size());
        for (Map.Entry<String, LogLevel> entry : newLoggerConfig.entrySet()) {
            String loggerName = entry.getKey();
            Level level = this.translateLoggerLevel(entry.getValue());
            log4j2LevelMap.put(loggerName, level);
        }
        Configurator.setLevel(log4j2LevelMap);
        return this;
    }

    private Level translateLoggerLevel(LogLevel value) {
        switch (value) {
            case ERROR: {
                return Level.ERROR;
            }
            case WARN: {
                return Level.WARN;
            }
            case INFO: {
                return Level.INFO;
            }
            case DEBUG: {
                return Level.DEBUG;
            }
            case TRACE: {
                return Level.TRACE;
            }
        }
        throw new IllegalStateException("Unexpected logger level value: " + value);
    }
}

