/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.servlet;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ApimanCorsFilter
implements Filter {
    public void init(FilterConfig config) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpReq = (HttpServletRequest)request;
        HttpServletResponse httpResp = (HttpServletResponse)response;
        if (this.isPreflightRequest(httpReq)) {
            httpResp.setHeader("Access-Control-Allow-Origin", httpReq.getHeader("Origin"));
            httpResp.setHeader("Access-Control-Allow-Credentials", "true");
            httpResp.setHeader("Access-Control-Max-Age", "1800");
            httpResp.setHeader("Access-Control-Allow-Methods", "GET,POST,PUT,HEAD,DELETE");
            httpResp.setHeader("Access-Control-Allow-Headers", "X-Requested-With,Content-Type,Accept,Origin,Authorization");
            httpResp.setHeader("Access-Control-Expose-Headers", "X-Apiman-Error");
        } else {
            if (this.hasOriginHeader(httpReq)) {
                httpResp.setHeader("Access-Control-Allow-Origin", httpReq.getHeader("Origin"));
                httpResp.setHeader("Access-Control-Allow-Credentials", "true");
                httpResp.setHeader("Access-Control-Expose-Headers", "X-Apiman-Error");
            }
            chain.doFilter((ServletRequest)httpReq, (ServletResponse)httpResp);
        }
    }

    protected boolean isPreflightRequest(HttpServletRequest httpReq) {
        return this.isOptionsMethod(httpReq) && this.hasOriginHeader(httpReq);
    }

    protected boolean isOptionsMethod(HttpServletRequest httpReq) {
        return "OPTIONS".equals(httpReq.getMethod());
    }

    protected boolean hasOriginHeader(HttpServletRequest httpReq) {
        String origin = httpReq.getHeader("Origin");
        return origin != null && origin.trim().length() > 0;
    }

    public void destroy() {
    }
}

