/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.TreeMap;

public class AbstractMessages {
    public static final List<String> FORMATS = Collections.unmodifiableList(Arrays.asList("java.properties"));
    private static Map<String, ResourceBundle> bundles = new HashMap<String, ResourceBundle>();
    private Class<? extends AbstractMessages> clazz;
    private static ThreadLocal<Locale> tlocale = new ThreadLocal();

    public static void setLocale(Locale locale) {
        tlocale.set(locale);
    }

    public static void clearLocale() {
        tlocale.set(null);
    }

    public AbstractMessages(Class<? extends AbstractMessages> c) {
        this.clazz = c;
    }

    private ResourceBundle getBundle() {
        String bundleKey = this.getBundleKey();
        if (bundles.containsKey(bundleKey)) {
            return bundles.get(bundleKey);
        }
        ResourceBundle bundle = this.loadBundle();
        bundles.put(bundleKey, bundle);
        return bundle;
    }

    private String getBundleKey() {
        Locale locale = this.getLocale();
        return this.clazz.getName() + "::" + locale.toString();
    }

    private ResourceBundle loadBundle() {
        String pkg = this.clazz.getPackage().getName();
        Locale locale = this.getLocale();
        return PropertyResourceBundle.getBundle(pkg + ".messages", locale, this.clazz.getClassLoader(), new ResourceBundle.Control(){

            @Override
            public List<String> getFormats(String baseName) {
                return FORMATS;
            }
        });
    }

    public Locale getLocale() {
        if (tlocale.get() != null) {
            return tlocale.get();
        }
        return Locale.getDefault();
    }

    public String format(String key, Object ... params) {
        ResourceBundle bundle = this.getBundle();
        if (bundle.containsKey(key)) {
            String msg = bundle.getString(key);
            return MessageFormat.format(msg, params);
        }
        return MessageFormat.format("!!{0}!!", key);
    }

    public Map<String, String> all() {
        TreeMap<String, String> rval = new TreeMap<String, String>();
        ResourceBundle bundle = this.getBundle();
        Enumeration<String> keys = bundle.getKeys();
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            rval.put(key, bundle.getString(key));
        }
        return rval;
    }
}

