/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.common.util;

import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AesEncrypter {
    private static final String secretKey = "f2f0aa80-84bd8a6";
    private static final Map<String, SecretKeySpec> keySpecs = new HashMap<String, SecretKeySpec>();

    private AesEncrypter() {
    }

    public static String encrypt(String plainText) {
        return AesEncrypter.encrypt(secretKey, plainText);
    }

    public static String encrypt(String secretKey, String plainText) {
        byte[] encrypted;
        Cipher cipher;
        if (plainText == null) {
            return null;
        }
        try {
            SecretKeySpec skeySpec = AesEncrypter.keySpecFromSecretKey(secretKey);
            cipher = Cipher.getInstance("AES");
            cipher.init(1, skeySpec);
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchPaddingException e) {
            throw new RuntimeException(e);
        }
        catch (InvalidKeyException e) {
            throw new RuntimeException(e);
        }
        try {
            encrypted = cipher.doFinal(plainText.getBytes());
        }
        catch (IllegalBlockSizeException e) {
            throw new RuntimeException(e);
        }
        catch (BadPaddingException e) {
            throw new RuntimeException(e);
        }
        return "$CRYPT::" + new String(Base64.encodeBase64((byte[])encrypted));
    }

    private static SecretKeySpec keySpecFromSecretKey(String secretKey) {
        if (!keySpecs.containsKey(secretKey)) {
            byte[] ivraw = secretKey.getBytes();
            SecretKeySpec skeySpec = new SecretKeySpec(ivraw, "AES");
            keySpecs.put(secretKey, skeySpec);
        }
        return keySpecs.get(secretKey);
    }

    public static final String decrypt(String encryptedText) {
        return AesEncrypter.decrypt(secretKey, encryptedText);
    }

    public static final String decrypt(String secretKey, String encryptedText) {
        if (encryptedText == null) {
            return null;
        }
        if (encryptedText.startsWith("$CRYPT::")) {
            Cipher cipher;
            byte[] decoded = Base64.decodeBase64((String)encryptedText.substring(8));
            try {
                SecretKeySpec skeySpec = AesEncrypter.keySpecFromSecretKey(secretKey);
                cipher = Cipher.getInstance("AES");
                cipher.init(2, skeySpec);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            catch (NoSuchPaddingException e) {
                throw new RuntimeException(e);
            }
            catch (InvalidKeyException e) {
                throw new RuntimeException(e);
            }
            try {
                String decryptedString = new String(cipher.doFinal(decoded));
                return decryptedString;
            }
            catch (IllegalBlockSizeException e) {
                throw new RuntimeException(e);
            }
            catch (BadPaddingException e) {
                throw new RuntimeException(e);
            }
        }
        return encryptedText;
    }

    public static final void main(String[] args) {
        if (args.length != 2) {
            AesEncrypter.printUsage();
            return;
        }
        String cmd = args[0];
        String input = args[1];
        if ("encrypt".equals(cmd)) {
            System.out.println(AesEncrypter.encrypt(input).substring("$CRYPT::".length()));
        } else if ("decrypt".equals(cmd)) {
            System.out.println(AesEncrypter.decrypt("$CRYPT::" + input));
        } else {
            AesEncrypter.printUsage();
        }
    }

    private static void printUsage() {
        System.out.println("Usage:");
        System.out.println("\tAesEncrypter encrypt|decrypt \"input\"\n------");
        System.out.println("Argument 1: the command, either 'encrypt' or 'decrypt'");
        System.out.println("Argument 2: the text to encrypt or decrypt (use quotes if the input contains spaces)");
        System.out.println("");
    }
}

