/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.impl;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IConnectorFactory;
import io.apiman.gateway.engine.IEngine;
import io.apiman.gateway.engine.IEngineResult;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.IServiceRequestExecutor;
import io.apiman.gateway.engine.Version;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Application;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.Policy;
import io.apiman.gateway.engine.beans.Service;
import io.apiman.gateway.engine.beans.ServiceContract;
import io.apiman.gateway.engine.beans.ServiceRequest;
import io.apiman.gateway.engine.beans.exceptions.ConfigurationParseException;
import io.apiman.gateway.engine.beans.exceptions.PolicyNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.impl.ServiceRequestExecutorImpl;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import io.apiman.gateway.engine.policy.PolicyContextImpl;
import io.apiman.gateway.engine.policy.PolicyWithConfiguration;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EngineImpl
implements IEngine {
    private IRegistry registry;
    private IComponentRegistry componentRegistry;
    private IConnectorFactory connectorFactory;
    private IPolicyFactory policyFactory;
    private Map<Policy, Object> policyConfigCache = new HashMap<Policy, Object>();

    public EngineImpl(IRegistry registry, IComponentRegistry componentRegistry, IConnectorFactory connectorFactory, IPolicyFactory policyFactory) {
        this.setRegistry(registry);
        this.setComponentRegistry(componentRegistry);
        this.setConnectorFactory(connectorFactory);
        this.setPolicyFactory(policyFactory);
    }

    @Override
    public String getVersion() {
        return Version.get().getVersionString();
    }

    @Override
    public IServiceRequestExecutor executor(ServiceRequest request, IAsyncResultHandler<IEngineResult> resultHandler) {
        ServiceContract serviceContract = this.getContract(request);
        request.setContract(serviceContract);
        return new ServiceRequestExecutorImpl(request, resultHandler, serviceContract, new PolicyContextImpl(this.getComponentRegistry()), this.getPolicies(serviceContract), this.getConnectorFactory());
    }

    @Override
    public void publishService(Service service) throws PublishingException {
        this.getRegistry().publishService(service);
    }

    @Override
    public void retireService(String organizationId, String serviceId, String version) throws PublishingException {
        Service svc = new Service();
        svc.setOrganizationId(organizationId);
        svc.setServiceId(serviceId);
        svc.setVersion(version);
        this.getRegistry().retireService(svc);
    }

    @Override
    public void registerApplication(Application application) throws RegistrationException {
        Set contracts = application.getContracts();
        for (Contract contract : contracts) {
            List policies = contract.getPolicies();
            for (Policy policy : policies) {
                try {
                    IPolicy policyImpl = this.getPolicyFactory().newPolicy(policy.getPolicyImpl());
                    policyImpl.parseConfiguration(policy.getPolicyJsonConfig());
                }
                catch (PolicyNotFoundException e) {
                    throw new RegistrationException((Exception)((Object)e));
                }
                catch (ConfigurationParseException e) {
                    throw new RegistrationException((Exception)((Object)e));
                }
            }
        }
        this.getRegistry().registerApplication(application);
    }

    @Override
    public void unregisterApplication(String organizationId, String applicationId, String version) throws RegistrationException {
        Application app = new Application();
        app.setOrganizationId(organizationId);
        app.setApplicationId(applicationId);
        app.setVersion(version);
        this.getRegistry().unregisterApplication(app);
    }

    private ServiceContract getContract(ServiceRequest request) {
        return this.getRegistry().getContract(request);
    }

    private List<PolicyWithConfiguration> getPolicies(ServiceContract contract) {
        ArrayList<PolicyWithConfiguration> instances = new ArrayList<PolicyWithConfiguration>();
        for (Policy policy : contract.getPolicies()) {
            IPolicy policyImpl = this.getPolicyFactory().newPolicy(policy.getPolicyImpl());
            Object policyConfig = this.getPolicyConfig(policyImpl, policy);
            PolicyWithConfiguration pwc = new PolicyWithConfiguration(policyImpl, policyConfig);
            instances.add(pwc);
        }
        return instances;
    }

    protected Object getPolicyConfig(IPolicy policyImpl, Policy policy) {
        Object parsedConfig = this.policyConfigCache.get(policy);
        if (parsedConfig == null) {
            parsedConfig = policyImpl.parseConfiguration(policy.getPolicyJsonConfig());
            this.policyConfigCache.put(policy, parsedConfig);
        }
        return parsedConfig;
    }

    public IRegistry getRegistry() {
        return this.registry;
    }

    public void setRegistry(IRegistry registry) {
        this.registry = registry;
    }

    public IConnectorFactory getConnectorFactory() {
        return this.connectorFactory;
    }

    public void setConnectorFactory(IConnectorFactory connectorFactory) {
        this.connectorFactory = connectorFactory;
    }

    public IPolicyFactory getPolicyFactory() {
        return this.policyFactory;
    }

    public void setPolicyFactory(IPolicyFactory policyFactory) {
        this.policyFactory = policyFactory;
    }

    public IComponentRegistry getComponentRegistry() {
        return this.componentRegistry;
    }

    public void setComponentRegistry(IComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }
}

