/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.policy;

import io.apiman.gateway.engine.IComponent;
import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.beans.exceptions.ComponentNotFoundException;
import io.apiman.gateway.engine.policy.IPolicyContext;
import java.util.HashMap;
import java.util.Map;

public class PolicyContextImpl
implements IPolicyContext {
    private final IComponentRegistry componentRegistry;
    private final Map<String, Object> conversation = new HashMap<String, Object>();

    public PolicyContextImpl(IComponentRegistry componentRegistry) {
        this.componentRegistry = componentRegistry;
    }

    @Override
    public void setAttribute(String name, Object value) {
        this.conversation.put(name, value);
    }

    @Override
    public <T> T getAttribute(String name, T defaultValue) {
        Object value = this.conversation.get(name);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    @Override
    public boolean removeAttribute(String name) {
        return this.conversation.remove(name) != null;
    }

    @Override
    public <T extends IComponent> T getComponent(Class<T> componentClass) throws ComponentNotFoundException {
        return this.componentRegistry.getComponent(componentClass);
    }
}

