/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.policy;

import io.apiman.gateway.engine.beans.exceptions.PolicyNotFoundException;
import io.apiman.gateway.engine.policy.IPolicy;
import io.apiman.gateway.engine.policy.IPolicyFactory;
import java.util.HashMap;
import java.util.Map;

public class PolicyFactoryImpl
implements IPolicyFactory {
    private Map<String, IPolicy> policyCache = new HashMap<String, IPolicy>();

    @Override
    public IPolicy newPolicy(String qualifiedName) throws PolicyNotFoundException {
        if (qualifiedName == null) {
            throw new PolicyNotFoundException(qualifiedName);
        }
        if (this.policyCache.containsKey(qualifiedName)) {
            return this.policyCache.get(qualifiedName);
        }
        IPolicy rval = null;
        if (qualifiedName.startsWith("class:")) {
            String classname = qualifiedName.substring(6);
            Class<?> c = null;
            try {
                c = Class.forName(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                c = this.getClass().getClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            try {
                c = Thread.currentThread().getContextClassLoader().loadClass(classname);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            if (c == null) {
                throw new PolicyNotFoundException(classname);
            }
            try {
                rval = (IPolicy)c.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new PolicyNotFoundException(qualifiedName, (Throwable)e);
            }
            this.policyCache.put(qualifiedName, rval);
            return rval;
        }
        throw new PolicyNotFoundException(qualifiedName);
    }
}

