/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.action.Action;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestResult;
import io.searchbox.cluster.Health;
import io.searchbox.indices.CreateIndex;
import io.searchbox.indices.IndicesExists;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;

public abstract class AbstractClientFactory {
    protected static Map<String, JestClient> clients = new HashMap<String, JestClient>();

    public static void clearClientCache() {
        clients.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClient(JestClient client, String indexName, String defaultIndexName) {
        try {
            client.execute((Action)new Health.Builder().build());
            IndicesExists action = new IndicesExists.Builder(indexName).build();
            Class<AbstractClientFactory> clazz = AbstractClientFactory.class;
            synchronized (AbstractClientFactory.class) {
                JestResult result = client.execute((Action)action);
                if (!result.isSucceeded()) {
                    this.createIndex(client, indexName, defaultIndexName + "-settings.json");
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        {
            return;
        }
    }

    protected void createIndex(JestClient client, String indexName, String settingsName) throws Exception {
        URL settings = AbstractClientFactory.class.getResource(settingsName);
        String source = IOUtils.toString((URL)settings);
        JestResult response = client.execute((Action)new CreateIndex.Builder(indexName).settings((Object)source).build());
        if (!response.isSucceeded() && !this.indexAlreadyExistsException(response)) {
            throw new Exception("Failed to create index: '" + indexName + "' Reason: " + response.getErrorMessage());
        }
    }

    private boolean indexAlreadyExistsException(JestResult response) {
        if (response.getErrorMessage().startsWith("IndexAlreadyExistsException")) {
            return true;
        }
        if (response.getJsonObject() == null || !response.getJsonObject().has("error")) {
            return false;
        }
        JsonObject error = response.getJsonObject().getAsJsonObject("error");
        if (!error.has("root_cause") || !error.get("root_cause").isJsonArray()) {
            return false;
        }
        JsonArray causes = error.getAsJsonArray("root_cause");
        for (JsonElement elem : causes) {
            JsonElement type;
            if (!elem.isJsonObject() || (type = elem.getAsJsonObject().get("type")) == null || !type.getAsString().equals("index_already_exists_exception")) continue;
            return true;
        }
        return false;
    }
}

