/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.es.DefaultESClientFactory;
import io.apiman.gateway.engine.es.IESClientFactory;
import io.apiman.gateway.engine.es.LocalClientFactory;
import io.searchbox.client.JestClient;
import java.util.Map;

public abstract class AbstractESComponent {
    private final Map<String, String> config;
    private JestClient esClient;
    private String indexName;

    public AbstractESComponent(Map<String, String> config) {
        this.config = config;
        String indexName = config.get("client.index");
        if (indexName == null) {
            indexName = this.getDefaultIndexName();
        }
        this.indexName = indexName;
    }

    public synchronized JestClient getClient() {
        if (this.esClient == null) {
            this.esClient = this.createClient();
        }
        return this.esClient;
    }

    protected JestClient createClient() {
        IESClientFactory factory = this.createEsClientFactory();
        return factory.createClient(this.config, this.getDefaultIndexName());
    }

    protected IESClientFactory createEsClientFactory() {
        String factoryClass = this.config.get("client.type");
        if ("jest".equals(factoryClass)) {
            factoryClass = DefaultESClientFactory.class.getName();
        } else if ("local".equals(factoryClass)) {
            factoryClass = LocalClientFactory.class.getName();
        } else if (factoryClass == null) {
            throw new RuntimeException("Invalid elasticsearch client type: " + factoryClass);
        }
        try {
            return (IESClientFactory)Class.forName(factoryClass).newInstance();
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("Error creating elasticsearch client type: " + factoryClass, e);
        }
    }

    protected abstract String getDefaultIndexName();

    protected String getIndexName() {
        return this.indexName;
    }
}

