/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.util.ssl.KeyStoreUtil;
import io.apiman.gateway.engine.es.AbstractClientFactory;
import io.apiman.gateway.engine.es.IESClientFactory;
import io.searchbox.client.JestClient;
import io.searchbox.client.JestClientFactory;
import io.searchbox.client.config.HttpClientConfig;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.nio.conn.SchemeIOSessionStrategy;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;

public class DefaultESClientFactory
extends AbstractClientFactory
implements IESClientFactory {
    public static void clearClientCache() {
        clients.clear();
    }

    @Override
    public JestClient createClient(Map<String, String> config, String defaultIndexName) {
        String indexName = config.get("client.index");
        if (indexName == null) {
            indexName = defaultIndexName;
        }
        JestClient client = this.createJestClient(config, indexName, defaultIndexName);
        return client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected JestClient createJestClient(Map<String, String> config, String indexName, String defaultIndexName) {
        String host = config.get("client.host");
        String port = config.get("client.port");
        String protocol = config.get("client.protocol");
        String initialize = config.get("client.initialize");
        if (initialize == null) {
            initialize = "true";
        }
        if (StringUtils.isBlank((CharSequence)host)) {
            throw new RuntimeException("Missing client.host configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((CharSequence)port)) {
            throw new RuntimeException("Missing client.port configuration for ESRegistry.");
        }
        if (StringUtils.isBlank((CharSequence)protocol)) {
            protocol = "http";
        }
        String clientKey = "jest:" + host + ':' + port + '/' + indexName;
        Map map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return (JestClient)clients.get(clientKey);
            }
            StringBuilder builder = new StringBuilder();
            builder.append(protocol);
            builder.append("://");
            builder.append(host);
            builder.append(":");
            builder.append(String.valueOf(port));
            String connectionUrl = builder.toString();
            JestClientFactory factory = new JestClientFactory();
            HttpClientConfig.Builder httpClientConfig = new HttpClientConfig.Builder(connectionUrl);
            this.updateHttpConfig(httpClientConfig, config);
            factory.setHttpClientConfig(httpClientConfig.build());
            this.updateJestClientFactory(factory, config);
            JestClient client = factory.getObject();
            clients.put(clientKey, client);
            if ("true".equals(initialize)) {
                this.initializeClient(client, indexName, defaultIndexName);
            }
            return client;
        }
    }

    protected void updateHttpConfig(HttpClientConfig.Builder httpClientConfig, Map<String, String> config) {
        String username = config.get("client.username");
        String password = config.get("client.password");
        String timeout = config.get("client.timeout");
        if (StringUtils.isBlank((CharSequence)timeout)) {
            timeout = "10000";
        }
        ((HttpClientConfig.Builder)((HttpClientConfig.Builder)httpClientConfig.connTimeout(new Integer(timeout).intValue())).readTimeout(new Integer(timeout).intValue())).maxTotalConnection(75).defaultMaxTotalConnectionPerRoute(75).multiThreaded(true);
        if (!StringUtils.isBlank((CharSequence)username)) {
            httpClientConfig.defaultCredentials(username, password);
        }
        if ("https".equals(config.get("protocol"))) {
            this.updateSslConfig(httpClientConfig, config);
        }
    }

    private void updateSslConfig(HttpClientConfig.Builder httpConfig, Map<String, String> config) {
        try {
            String clientKeystorePath = config.get("client-keystore");
            String clientKeystorePassword = config.get("client-keystore.password");
            String trustStorePath = config.get("trust-store");
            String trustStorePassword = config.get("trust-store.password");
            SSLContext sslContext = SSLContext.getInstance("TLS");
            KeyStoreUtil.Info kPathInfo = new KeyStoreUtil.Info(clientKeystorePath, clientKeystorePassword);
            KeyStoreUtil.Info tPathInfo = new KeyStoreUtil.Info(trustStorePath, trustStorePassword);
            sslContext.init(KeyStoreUtil.getKeyManagers((KeyStoreUtil.Info)kPathInfo), KeyStoreUtil.getTrustManagers((KeyStoreUtil.Info)tPathInfo), null);
            DefaultHostnameVerifier hostnameVerifier = new DefaultHostnameVerifier();
            SSLConnectionSocketFactory sslSocketFactory = new SSLConnectionSocketFactory(sslContext, (HostnameVerifier)hostnameVerifier);
            SSLIOSessionStrategy httpsIOSessionStrategy = new SSLIOSessionStrategy(sslContext, (HostnameVerifier)hostnameVerifier);
            httpConfig.defaultSchemeForDiscoveredNodes("https");
            httpConfig.sslSocketFactory((LayeredConnectionSocketFactory)sslSocketFactory);
            httpConfig.httpsIOSessionStrategy((SchemeIOSessionStrategy)httpsIOSessionStrategy);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void updateJestClientFactory(JestClientFactory factory, Map<String, String> config) {
    }
}

