/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.IComponentRegistry;
import io.apiman.gateway.engine.IMetrics;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.metrics.RequestMetric;
import io.searchbox.action.Action;
import io.searchbox.action.BulkableAction;
import io.searchbox.core.Bulk;
import io.searchbox.core.BulkResult;
import io.searchbox.core.Index;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;

public class ESMetrics
extends AbstractESComponent
implements IMetrics {
    private static final int DEFAULT_QUEUE_SIZE = 10000;
    private static final int DEFAULT_BATCH_SIZE = 1000;
    protected IComponentRegistry componentRegistry;
    private final BlockingQueue<RequestMetric> queue;
    private final int batchSize;

    public ESMetrics(Map<String, String> config) {
        super(config);
        int queueSize = 10000;
        String queueSizeConfig = config.get("queue.size");
        if (queueSizeConfig != null) {
            queueSize = new Integer(queueSizeConfig);
        }
        this.queue = new LinkedBlockingDeque<RequestMetric>(queueSize);
        int batchSize = 1000;
        String batchSizeConfig = config.get("batch.size");
        if (batchSizeConfig != null) {
            batchSize = new Integer(batchSizeConfig);
        }
        this.batchSize = batchSize;
        this.startConsumerThread();
    }

    public void setComponentRegistry(IComponentRegistry registry) {
        this.componentRegistry = registry;
    }

    public void record(RequestMetric metric) {
        try {
            this.queue.put(metric);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void startConsumerThread() {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                while (Boolean.TRUE.booleanValue()) {
                    ESMetrics.this.processQueue();
                }
            }
        }, "ESMetricsConsumer");
        thread.setDaemon(true);
        thread.start();
    }

    protected void processQueue() {
        try {
            ArrayList<RequestMetric> batch = new ArrayList<RequestMetric>(this.batchSize);
            RequestMetric rm = this.queue.take();
            batch.add(rm);
            this.queue.drainTo(batch, this.batchSize - 1);
            Bulk.Builder builder = new Bulk.Builder();
            for (RequestMetric metric : batch) {
                Index index = ((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)metric).refresh(false)).index(this.getIndexName())).type("request")).build();
                builder.addAction((BulkableAction)index);
            }
            BulkResult result = (BulkResult)this.getClient().execute((Action)builder.build());
            if (!result.isSucceeded()) {
                System.err.println("Failed to add metric(s) to ES: " + result.getErrorMessage());
            }
        }
        catch (Exception e) {
            System.err.println("Error adding metric to ES:");
            e.printStackTrace();
            return;
        }
    }

    @Override
    protected String getDefaultIndexName() {
        return "apiman_metrics";
    }
}

