/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.IRateLimiterComponent;
import io.apiman.gateway.engine.components.rate.RateLimitResponse;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.rates.RateBucketPeriod;
import io.apiman.gateway.engine.rates.RateLimiterBucket;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;

public class ESRateLimiterComponent
extends AbstractESComponent
implements IRateLimiterComponent {
    public ESRateLimiterComponent(Map<String, String> config) {
        super(config);
    }

    public void accept(String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        String id = this.id(bucketId);
        try {
            RateLimiterBucket bucket;
            long version;
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("rateBucket")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                version = result.getJsonObject().get("_version").getAsLong();
                bucket = (RateLimiterBucket)result.getSourceAsObject(RateLimiterBucket.class);
            } else {
                version = 0L;
                bucket = new RateLimiterBucket();
            }
            bucket.resetIfNecessary(period);
            RateLimitResponse rlr = new RateLimitResponse();
            if (bucket.getCount() > limit) {
                rlr.setAccepted(false);
            } else {
                rlr.setAccepted(bucket.getCount() < limit);
                bucket.setCount(bucket.getCount() + increment);
                bucket.setLast(System.currentTimeMillis());
            }
            int reset = (int)(bucket.getResetMillis(period) / 1000L);
            rlr.setReset((long)reset);
            rlr.setRemaining(limit - bucket.getCount());
            this.updateBucketAndReturn(id, bucket, rlr, version, bucketId, period, limit, increment, handler);
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, RateLimitResponse.class));
        }
    }

    protected void updateBucketAndReturn(String id, RateLimiterBucket bucket, RateLimitResponse rlr, long version, String bucketId, RateBucketPeriod period, long limit, long increment, IAsyncResultHandler<RateLimitResponse> handler) {
        Index.Builder builder = (Index.Builder)((Index.Builder)new Index.Builder((Object)bucket).refresh(false)).index(this.getIndexName());
        if (version > 0L) {
            builder.setParameter("version", (Object)String.valueOf(version));
        }
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)builder.setParameter("op_type", (Object)"index")).type("rateBucket")).id(id)).build();
        try {
            this.getClient().execute((Action)index);
            handler.handle((Object)AsyncResultImpl.create((Object)rlr));
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private String id(String bucketId) {
        return Base64.encodeBase64String((byte[])bucketId.getBytes());
    }

    @Override
    protected String getDefaultIndexName() {
        return "apiman_gateway";
    }
}

