/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.common.es.util.ESUtils;
import io.apiman.gateway.engine.IRegistry;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.ApiContract;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.beans.Contract;
import io.apiman.gateway.engine.beans.exceptions.ApiNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.ApiRetiredException;
import io.apiman.gateway.engine.beans.exceptions.ClientNotFoundException;
import io.apiman.gateway.engine.beans.exceptions.NoContractFoundException;
import io.apiman.gateway.engine.beans.exceptions.PublishingException;
import io.apiman.gateway.engine.beans.exceptions.RegistrationException;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.i18n.Messages;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Delete;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import io.searchbox.core.Search;
import io.searchbox.core.SearchResult;
import io.searchbox.core.search.aggregation.MetricAggregation;
import io.searchbox.core.search.aggregation.TermsAggregation;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ESRegistry
extends AbstractESComponent
implements IRegistry {
    public ESRegistry(Map<String, String> config) {
        super(config);
    }

    public void publishApi(Api api, IAsyncResultHandler<Void> handler) {
        try {
            String id = this.getApiId(api);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)api).refresh(false)).index(this.getIndexName())).setParameter("op_type", (Object)"index")).type("api")).id(id)).build();
            JestResult result = this.getClient().execute((Action)index);
            if (!result.isSucceeded()) {
                throw new IOException(result.getErrorMessage());
            }
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorPublishingApi", new Object[0]), (Throwable)e), Void.class));
        }
    }

    public void retireApi(Api api, IAsyncResultHandler<Void> handler) {
        String id = this.getApiId(api);
        try {
            Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("api")).build();
            JestResult result = this.getClient().execute((Action)delete);
            if (result.isSucceeded()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new ApiNotFoundException(Messages.i18n.format("ESRegistry.ApiNotFound", new Object[0]))));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorRetiringApi", new Object[0]), (Throwable)e)));
        }
    }

    public void registerClient(Client client, IAsyncResultHandler<Void> handler) {
        try {
            this.validateClient(client);
            String id = this.getClientId(client);
            Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)client).refresh(false)).index(this.getIndexName())).setParameter("op_type", (Object)"index")).type("client")).id(id)).build();
            JestResult result = this.getClient().execute((Action)index);
            if (!result.isSucceeded()) {
                throw new IOException(result.getErrorMessage());
            }
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new RegistrationException(Messages.i18n.format("ESRegistry.ErrorRegisteringClient", new Object[0]), (Throwable)e), Void.class));
        }
        catch (RuntimeException re) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)re, Void.class));
        }
    }

    private void validateClient(Client client) throws RegistrationException {
        Set contracts = client.getContracts();
        if (contracts.isEmpty()) {
            throw new NoContractFoundException(Messages.i18n.format("ESRegistry.NoContracts", new Object[0]));
        }
        for (Contract contract : contracts) {
            this.validateContract(contract);
        }
    }

    private void validateContract(Contract contract) throws RegistrationException {
        String id = this.getApiId(contract);
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("api")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (!result.isSucceeded()) {
                String apiId = contract.getApiId();
                String orgId = contract.getApiOrgId();
                throw new ApiNotFoundException(Messages.i18n.format("ESRegistry.ApiNotFoundInOrg", new Object[]{apiId, orgId}));
            }
        }
        catch (IOException e) {
            throw new RegistrationException(Messages.i18n.format("ESRegistry.ErrorValidatingClient", new Object[0]), (Throwable)e);
        }
    }

    public void unregisterClient(Client client, IAsyncResultHandler<Void> handler) {
        try {
            Client lclient = this.lookupClient(client.getOrganizationId(), client.getClientId(), client.getVersion());
            String id = this.getClientId(lclient);
            Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("client")).build();
            JestResult result = this.getClient().execute((Action)delete);
            if (result.isSucceeded()) {
                handler.handle((Object)AsyncResultImpl.create((Object)null));
            } else {
                handler.handle((Object)AsyncResultImpl.create((Throwable)new ClientNotFoundException(Messages.i18n.format("ESRegistry.ClientNotFound", new Object[0])), Void.class));
            }
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new PublishingException(Messages.i18n.format("ESRegistry.ErrorUnregisteringClient", new Object[0]), (Throwable)e), Void.class));
        }
        catch (RuntimeException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private Client lookupClient(String orgId, String clientId, String version) {
        String query = "{  \"query\": {        \"bool\": {            \"filter\": [{                    \"term\": {                        \"organizationId\": ?                     }          },          {                    \"term\": {                        \"clientId\": ?                     }          },          {                    \"term\": {                        \"version\": ?           }      }            ]    }  }}";
        String escaped = ESUtils.queryWithEscapedArgs((String)query, (String[])new String[]{orgId, clientId, version});
        try {
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(escaped).addIndex(this.getIndexName())).addType("client")).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            if (!response.isSucceeded()) {
                throw new RuntimeException(response.getErrorMessage());
            }
            if (response.getTotal() < 1L) {
                throw new IOException();
            }
            SearchResult.Hit hit = response.getFirstHit(Client.class);
            return (Client)hit.source;
        }
        catch (IOException e) {
            throw new ClientNotFoundException(Messages.i18n.format("ESRegistry.ClientNotFound", new Object[0]), (Exception)e);
        }
    }

    public void getApi(String organizationId, String apiId, String apiVersion, IAsyncResultHandler<Api> handler) {
        String id = this.getApiId(organizationId, apiId, apiVersion);
        try {
            Api api = this.getApi(id);
            handler.handle((Object)AsyncResultImpl.create((Object)api));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Api.class));
        }
    }

    public void getClient(String organizationId, String clientId, String clientVersion, IAsyncResultHandler<Client> handler) {
        try {
            Client client = this.lookupClient(organizationId, clientId, clientVersion);
            handler.handle((Object)AsyncResultImpl.create((Object)client));
        }
        catch (ClientNotFoundException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Client.class));
        }
    }

    protected Api getApi(String id) throws IOException {
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("api")).build();
        JestResult result = this.getClient().execute((Action)get);
        if (result.isSucceeded()) {
            Api api = (Api)result.getSourceAsObject(Api.class);
            return api;
        }
        return null;
    }

    public void getClient(String apiKey, IAsyncResultHandler<Client> handler) {
        String id = apiKey;
        try {
            Client client = this.getClient(id);
            handler.handle((Object)AsyncResultImpl.create((Object)client));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, Client.class));
        }
    }

    protected Client getClient(String id) throws IOException {
        Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("client")).build();
        JestResult result = this.getClient().execute((Action)get);
        if (result.isSucceeded()) {
            Client client = (Client)result.getSourceAsObject(Client.class);
            return client;
        }
        return null;
    }

    public void getContract(String apiOrganizationId, String apiId, String apiVersion, String apiKey, IAsyncResultHandler<ApiContract> handler) {
        try {
            Client client = this.getClient(apiKey);
            Api api = this.getApi(this.getApiId(apiOrganizationId, apiId, apiVersion));
            if (client == null) {
                ClientNotFoundException error = new ClientNotFoundException(Messages.i18n.format("ESRegistry.NoClientForAPIKey", new Object[]{apiKey}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            if (api == null) {
                ApiRetiredException error = new ApiRetiredException(Messages.i18n.format("ESRegistry.ApiWasRetired", new Object[]{apiId, apiOrganizationId}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            Contract matchedContract = null;
            for (Contract contract : client.getContracts()) {
                if (!contract.matches(apiOrganizationId, apiId, apiVersion)) continue;
                matchedContract = contract;
                break;
            }
            if (matchedContract == null) {
                NoContractFoundException error = new NoContractFoundException(Messages.i18n.format("ESRegistry.NoContractFound", new Object[]{client.getClientId(), api.getApiId()}));
                handler.handle((Object)AsyncResultImpl.create((Throwable)error, ApiContract.class));
                return;
            }
            ApiContract contract = new ApiContract(api, client, matchedContract.getPlan(), matchedContract.getPolicies());
            handler.handle((Object)AsyncResultImpl.create((Object)contract));
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e, ApiContract.class));
        }
    }

    public void listClients(String organizationId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            String query = "{      \"query\": {        \"bool\": {          \"filter\": [            {              \"exists\": {                \"field\": \"clientId\"               }            },            {              \"term\": {                \"organizationId\": ?               }            }          ]        }    },    \"aggs\": {        \"clients\": {            \"terms\": {                \"field\": \"clientId\"             }        }    }}";
            String escaped = ESUtils.queryWithEscapedArgs((String)query, (String[])new String[]{organizationId});
            Search search = ((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(escaped).addIndex(this.getIndexName())).addType("client")).setParameter("size", (Object)0)).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            MetricAggregation aggregation = response.getAggregations();
            TermsAggregation terms = aggregation.getTermsAggregation("clients");
            List results = terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public void listApis(String organizationId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            String query = "{      \"query\": {        \"bool\": {          \"filter\": [            {              \"exists\": {                \"field\": \"apiId\"               }            },            {              \"term\": {                \"organizationId\": ?               }            }          ]        }    },    \"aggs\": {        \"apis\": {            \"terms\": {                \"field\": \"apiId\"             }        }    }}";
            String escaped = ESUtils.queryWithEscapedArgs((String)query, (String[])new String[]{organizationId});
            Search search = ((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(escaped).addIndex(this.getIndexName())).addType("api")).setParameter("size", (Object)0)).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            MetricAggregation aggregation = response.getAggregations();
            TermsAggregation terms = aggregation.getTermsAggregation("apis");
            List results = terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public void listOrgs(IAsyncResultHandler<List<String>> handler) {
        try {
            String query = "{\n    \"aggs\" : {\n        \"all_orgs\" : {\n            \"terms\" : { \"field\" : \"organizationId\" }\n        }\n    }\n}";
            Search search = ((Search.Builder)((Search.Builder)new Search.Builder(query).addIndex(this.getIndexName())).setParameter("size", (Object)0)).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            MetricAggregation aggregation = response.getAggregations();
            TermsAggregation terms = aggregation.getTermsAggregation("all_orgs");
            List results = terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public void listClientVersions(String organizationId, String clientId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            String query = "{  \"query\": {    \"bool\": {      \"filter\": [        {          \"term\": {            \"organizationId\": ?          }        },        {          \"term\": {            \"clientId\": ?          }        }      ]    }  },    \"aggs\": {      \"client_versions\": {        \"terms\": {          \"field\": \"version\"        }      }    }}";
            String escaped = ESUtils.queryWithEscapedArgs((String)query, (String[])new String[]{organizationId, clientId});
            Search search = ((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(escaped).addIndex(this.getIndexName())).addType("client")).setParameter("size", (Object)0)).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            MetricAggregation aggregation = response.getAggregations();
            TermsAggregation terms = aggregation.getTermsAggregation("client_versions");
            List results = terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public void listApiVersions(String organizationId, String apiId, int page, int pageSize, IAsyncResultHandler<List<String>> handler) {
        try {
            String query = "{  \"query\": {    \"bool\": {      \"filter\": [        {          \"term\": {            \"organizationId\": ?          }        },        {          \"term\": {            \"apiId\": ?          }        }      ]    }  },    \"aggs\": {      \"api_versions\": {        \"terms\": {          \"field\": \"version\"        }      }    }}";
            String escaped = ESUtils.queryWithEscapedArgs((String)query, (String[])new String[]{organizationId, apiId});
            Search search = ((Search.Builder)((Search.Builder)((Search.Builder)new Search.Builder(escaped).addIndex(this.getIndexName())).addType("api")).setParameter("size", (Object)0)).build();
            SearchResult response = (SearchResult)this.getClient().execute((Action)search);
            MetricAggregation aggregation = response.getAggregations();
            TermsAggregation terms = aggregation.getTermsAggregation("api_versions");
            List results = terms.getBuckets().stream().map(TermsAggregation.Entry::getKey).collect(Collectors.toList());
            handler.handle((Object)AsyncResultImpl.create(results));
        }
        catch (IOException e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private String getApiId(Api api) {
        return this.getApiId(api.getOrganizationId(), api.getApiId(), api.getVersion());
    }

    private String getApiId(Contract contract) {
        return this.getApiId(contract.getApiOrgId(), contract.getApiId(), contract.getApiVersion());
    }

    protected String getApiId(String orgId, String apiId, String version) {
        return ESUtils.escape((String)(orgId + ":" + apiId + ":" + version));
    }

    protected String getClientId(Client client) {
        return client.getApiKey();
    }

    @Override
    protected String getDefaultIndexName() {
        return "apiman_gateway";
    }
}

