/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.apiman.gateway.engine.async.AsyncResultImpl;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.components.ISharedStateComponent;
import io.apiman.gateway.engine.es.AbstractESComponent;
import io.apiman.gateway.engine.es.beans.PrimitiveBean;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.core.Delete;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.codec.binary.Base64;

public class ESSharedStateComponent
extends AbstractESComponent
implements ISharedStateComponent {
    private static final ObjectMapper mapper = new ObjectMapper();

    public ESSharedStateComponent(Map<String, String> config) {
        super(config);
    }

    public <T> void getProperty(String namespace, String propertyName, T defaultValue, IAsyncResultHandler<T> handler) {
        if (defaultValue == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null defaultValue is not allowed.")));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getIndexName(), id).type("sharedStateProperty")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                try {
                    Object value = defaultValue.getClass().isPrimitive() || defaultValue instanceof String ? this.readPrimitive(result) : result.getSourceAsObject(defaultValue.getClass());
                    handler.handle((Object)AsyncResultImpl.create((Object)value));
                }
                catch (Exception e) {
                    handler.handle((Object)AsyncResultImpl.create((Throwable)e));
                }
            } else {
                handler.handle((Object)AsyncResultImpl.create(defaultValue));
            }
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void setProperty(String namespace, String propertyName, T value, IAsyncResultHandler<Void> handler) {
        String source;
        if (value == null) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)new Exception("Null value is not allowed.")));
            return;
        }
        try {
            if (value.getClass().isPrimitive() || value instanceof String) {
                PrimitiveBean pb = new PrimitiveBean();
                pb.setValue(String.valueOf(value));
                pb.setType(value.getClass().getName());
                source = mapper.writeValueAsString((Object)pb);
            } else {
                source = mapper.writeValueAsString(value);
            }
        }
        catch (Exception e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
            return;
        }
        String id = this.getPropertyId(namespace, propertyName);
        String json = source;
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)json).refresh(false)).index(this.getIndexName())).type("sharedStateProperty")).id(id)).build();
        try {
            this.getClient().execute((Action)index);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    public <T> void clearProperty(String namespace, String propertyName, IAsyncResultHandler<Void> handler) {
        String id = this.getPropertyId(namespace, propertyName);
        Delete delete = ((Delete.Builder)((Delete.Builder)new Delete.Builder(id).index(this.getIndexName())).type("sharedStateProperty")).build();
        try {
            this.getClient().execute((Action)delete);
            handler.handle((Object)AsyncResultImpl.create((Object)null));
        }
        catch (Throwable e) {
            handler.handle((Object)AsyncResultImpl.create((Throwable)e));
        }
    }

    private String getPropertyId(String namespace, String propertyName) {
        String qn = new QName(namespace, propertyName).toString();
        return Base64.encodeBase64String((byte[])qn.getBytes());
    }

    protected Object readPrimitive(JestResult result) throws Exception {
        PrimitiveBean pb = (PrimitiveBean)result.getSourceAsObject(PrimitiveBean.class);
        String value = pb.getValue();
        Class<?> c = Class.forName(pb.getType());
        if (c == String.class) {
            return value;
        }
        if (c == Long.class) {
            return Long.parseLong(value);
        }
        if (c == Integer.class) {
            return Integer.parseInt(value);
        }
        if (c == Double.class) {
            return Double.parseDouble(value);
        }
        if (c == Boolean.class) {
            return Boolean.parseBoolean(value);
        }
        if (c == Byte.class) {
            return Byte.parseByte(value);
        }
        if (c == Short.class) {
            return Short.parseShort(value);
        }
        if (c == Float.class) {
            return Float.valueOf(Float.parseFloat(value));
        }
        throw new Exception("Unsupported primitive: " + c);
    }

    @Override
    protected String getDefaultIndexName() {
        return "apiman_gateway";
    }

    static {
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

