/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.es.AbstractClientFactory;
import io.apiman.gateway.engine.es.IESClientFactory;
import io.searchbox.client.JestClient;
import java.lang.reflect.Field;
import java.util.Map;

public class LocalClientFactory
extends AbstractClientFactory
implements IESClientFactory {
    @Override
    public JestClient createClient(Map<String, String> config, String defaultIndexName) {
        String indexName = config.get("client.index");
        if (indexName == null) {
            indexName = defaultIndexName;
        }
        JestClient client = this.createLocalClient(config, indexName, defaultIndexName);
        return client;
    }

    public JestClient createLocalClient(Map<String, String> config, String indexName, String defaultIndexName) {
        String clientLocClassName = config.get("client.class");
        String clientLocFieldName = config.get("client.field");
        return this.createLocalClient(clientLocClassName, clientLocFieldName, indexName, defaultIndexName);
    }

    public JestClient createLocalClient(String className, String fieldName, String indexName, String defaultIndexName) {
        String clientKey = "local:" + className + '/' + fieldName;
        Map map = clients;
        synchronized (map) {
            if (clients.containsKey(clientKey)) {
                return (JestClient)clients.get(clientKey);
            }
            try {
                Class<?> clientLocClass = Class.forName(className);
                Field field = clientLocClass.getField(fieldName);
                JestClient client = (JestClient)field.get(null);
                clients.put(clientKey, client);
                this.initializeClient(client, indexName, defaultIndexName);
                return client;
            }
            catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchFieldException | SecurityException e) {
                throw new RuntimeException("Error using local elasticsearch client.", e);
            }
        }
    }
}

