/*
 * Decompiled with CFR 0.152.
 */
package io.apiman.gateway.engine.es;

import io.apiman.gateway.engine.async.IAsyncResult;
import io.apiman.gateway.engine.async.IAsyncResultHandler;
import io.apiman.gateway.engine.beans.Api;
import io.apiman.gateway.engine.beans.Client;
import io.apiman.gateway.engine.es.CachingESRegistry;
import io.apiman.gateway.engine.es.beans.DataVersionBean;
import io.searchbox.action.Action;
import io.searchbox.client.JestResult;
import io.searchbox.client.JestResultHandler;
import io.searchbox.core.Get;
import io.searchbox.core.Index;
import java.io.IOException;
import java.util.Map;

public class PollCachingESRegistry
extends CachingESRegistry {
    private static final int DEFAULT_POLLING_INTERVAL = 10;
    private static final int DEFAULT_STARTUP_DELAY = 30;
    private int pollIntervalMillis;
    private int startupDelayMillis;
    private boolean polling = false;
    private String dataVersion = null;

    public PollCachingESRegistry(Map<String, String> config) {
        super(config);
        String intervalVal = config.get("cache-polling-interval");
        String startupVal = config.get("cache-polling-startup-delay");
        this.pollIntervalMillis = intervalVal != null ? new Integer(intervalVal) * 1000 : 10000;
        this.startupDelayMillis = startupVal != null ? new Integer(startupVal) * 1000 : 30000;
        this.startCacheInvalidator();
    }

    @Override
    public void publishApi(Api api, final IAsyncResultHandler<Void> handler) {
        super.publishApi(api, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void retireApi(Api api, final IAsyncResultHandler<Void> handler) {
        super.retireApi(api, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void registerClient(Client client, final IAsyncResultHandler<Void> handler) {
        super.registerClient(client, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    @Override
    public void unregisterClient(Client client, final IAsyncResultHandler<Void> handler) {
        super.unregisterClient(client, new IAsyncResultHandler<Void>(){

            public void handle(IAsyncResult<Void> result) {
                if (result.isSuccess()) {
                    PollCachingESRegistry.this.updateDataVersion();
                }
                handler.handle(result);
            }
        });
    }

    protected void updateDataVersion() {
        DataVersionBean dv = new DataVersionBean();
        dv.setUpdatedOn(System.currentTimeMillis());
        Index index = ((Index.Builder)((Index.Builder)((Index.Builder)((Index.Builder)new Index.Builder((Object)dv).refresh(false)).index(this.getDefaultIndexName())).type("dataVersion")).id("instance")).build();
        this.getClient().executeAsync((Action)index, (JestResultHandler)new JestResultHandler<JestResult>(){

            public void completed(JestResult result) {
                PollCachingESRegistry.this.dataVersion = null;
            }

            public void failed(Exception e) {
                PollCachingESRegistry.this.dataVersion = null;
            }
        });
    }

    protected void startCacheInvalidator() {
        this.polling = true;
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Thread.sleep(PollCachingESRegistry.this.startupDelayMillis);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
                while (PollCachingESRegistry.this.polling) {
                    try {
                        Thread.sleep(PollCachingESRegistry.this.pollIntervalMillis);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    PollCachingESRegistry.this.checkCacheVersion();
                }
            }
        }, "ESRegistryCacheInvalidator");
        thread.setDaemon(true);
        thread.start();
    }

    public void stop() {
        this.polling = false;
    }

    protected void checkCacheVersion() {
        boolean invalidate = true;
        try {
            Get get = ((Get.Builder)new Get.Builder(this.getDefaultIndexName(), "instance").type("dataVersion")).build();
            JestResult result = this.getClient().execute((Action)get);
            if (result.isSucceeded()) {
                String latestDV = result.getJsonObject().get("_version").getAsString();
                if (latestDV != null && this.dataVersion != null && latestDV.equals(this.dataVersion)) {
                    invalidate = false;
                } else {
                    this.dataVersion = latestDV;
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (invalidate) {
            this.invalidateCache();
        }
    }
}

